"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    service_name: str,
    power: str,
    scale: int,
    tags: List = None,
    public_domain_names: Dict = None,
    deployment: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Lightsail container service. A Lightsail container service is a compute resource to which you can deploy containers. For more information, see Container services in Amazon Lightsail in the Lightsail Dev Guide.

    Args:
        service_name(str): The name for the container service. The name that you specify for your container service will make up part of its default domain. The default domain of a container service is typically https://<ServiceName>.<RandomGUID>.<AWSRegion>.cs.amazonlightsail.com. If the name of your container service is container-service-1, and it's located in the US East (Ohio) AWS region (us-east-2), then the domain for your container service will be like the following example: https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com  The following are the requirements for container service names:   Must be unique within each AWS Region in your Lightsail account.   Must contain 1 to 63 characters.   Must contain only alphanumeric characters and hyphens.   A hyphen (-) can separate words but cannot be at the start or end of the name.  .
        power(str): The power specification for the container service. The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The power and scale of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the power with the scale (the number of nodes) of the service. Use the GetContainerServicePowers action to get a list of power options that you can specify using this parameter, and their base monthly cost.
        scale(int): The scale specification for the container service. The scale specifies the allocated compute nodes of the container service. The power and scale of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the power with the scale (the number of nodes) of the service.
        tags(List, optional): The tag keys and optional values to add to the certificate during create. Use the TagResource action to tag a resource after it's created. For more information about tags in Lightsail, see the Amazon Lightsail Developer Guide. Defaults to None.
        public_domain_names(Dict, optional): The public domain names to use with the container service, such as example.com and www.example.com. You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service. If you don't specify public domain names, then you can use the default domain of the container service.  You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the CreateCertificate action to create a certificate for the public domain names you want to use with your container service.  You can specify public domain names using a string to array map as shown in the example later on this page. Defaults to None.
        deployment(Dict, optional): An object that describes a deployment for the container service. A deployment specifies the containers that will be launched on the container service and their settings, such as the ports to open, the environment variables to apply, and the launch command to run. It also specifies the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the health check configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.service.init.create(
                ctx, service_name=value, power=value, scale=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.service.init.create service_name=value, power=value, scale=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_container_service",
        op_kwargs={
            "serviceName": service_name,
            "power": power,
            "scale": scale,
            "tags": tags,
            "publicDomainNames": public_domain_names,
            "deployment": deployment,
        },
    )


async def delete(hub, ctx, service_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes your Amazon Lightsail container service.

    Args:
        service_name(str): The name of the container service to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.service.init.delete(ctx, service_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.service.init.delete service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_container_service",
        op_kwargs={"serviceName": service_name},
    )


async def get_all(hub, ctx, service_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about one or more of your Amazon Lightsail container services.

    Args:
        service_name(str, optional): The name of the container service for which to return information. When omitted, the response includes all of your container services in the AWS Region where the request is made. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.service.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.service.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_container_services",
        op_kwargs={"serviceName": service_name},
    )


async def update(
    hub,
    ctx,
    service_name: str,
    power: str = None,
    scale: int = None,
    is_disabled: bool = None,
    public_domain_names: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration of your Amazon Lightsail container service, such as its power, scale, and public domain names.

    Args:
        service_name(str): The name of the container service to update.
        power(str, optional): The power for the container service. The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The power and scale of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the power with the scale (the number of nodes) of the service. Use the GetContainerServicePowers action to view the specifications of each power option. Defaults to None.
        scale(int, optional): The scale for the container service. The scale specifies the allocated compute nodes of the container service. The power and scale of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the power with the scale (the number of nodes) of the service. Defaults to None.
        is_disabled(bool, optional): A Boolean value to indicate whether the container service is disabled. Defaults to None.
        public_domain_names(Dict, optional): The public domain names to use with the container service, such as example.com and www.example.com. You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service. If you don't specify public domain names, then you can use the default domain of the container service.  You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the CreateCertificate action to create a certificate for the public domain names you want to use with your container service.  You can specify public domain names using a string to array map as shown in the example later on this page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.service.init.update(ctx, service_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.service.init.update service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="update_container_service",
        op_kwargs={
            "serviceName": service_name,
            "power": power,
            "scale": scale,
            "isDisabled": is_disabled,
            "publicDomainNames": public_domain_names,
        },
    )
