"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, service_name: str, containers: Dict = None, public_endpoint: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a deployment for your Amazon Lightsail container service. A deployment specifies the containers that will be launched on the container service and their settings, such as the ports to open, the environment variables to apply, and the launch command to run. It also specifies the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the health check configuration. You can deploy containers to your container service using container images from a public registry like Docker Hub, or from your local machine. For more information, see Creating container images for your Amazon Lightsail container services in the Amazon Lightsail Developer Guide.

    Args:
        service_name(str): The name of the container service for which to create the deployment.
        containers(Dict, optional): An object that describes the settings of the containers that will be launched on the container service. Defaults to None.
        public_endpoint(Dict, optional): An object that describes the settings of the public endpoint for the container service. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.service.deployment.create(
                ctx, service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.service.deployment.create service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_container_service_deployment",
        op_kwargs={
            "serviceName": service_name,
            "containers": containers,
            "publicEndpoint": public_endpoint,
        },
    )


async def get_all(hub, ctx, service_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the deployments for your Amazon Lightsail container service A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to your container service. The deployments are ordered by version in ascending order. The newest version is listed at the top of the response.  A set number of deployments are kept before the oldest one is replaced with the newest one. For more information, see Amazon Lightsail endpoints and quotas in the AWS General Reference.

    Args:
        service_name(str): The name of the container service for which to return deployments.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.service.deployment.get_all(
                ctx, service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.service.deployment.get_all service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_container_service_deployments",
        op_kwargs={"serviceName": service_name},
    )
