"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, service_name: str, image: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a container image that is registered to your Amazon Lightsail container service.

    Args:
        service_name(str): The name of the container service for which to delete a registered container image.
        image(str): The name of the container image to delete from the container service. Use the GetContainerImages action to get the name of the container images that are registered to a container service.  Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (:). For example, :container-service-1.mystaticwebsite.1. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, nginx:latest or nginx. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.image.delete(
                ctx, service_name=value, image=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.image.delete service_name=value, image=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_container_image",
        op_kwargs={"serviceName": service_name, "image": image},
    )


async def get_all(hub, ctx, service_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the container images that are registered to your Amazon Lightsail container service.  If you created a deployment on your Lightsail container service that uses container images from a public registry like Docker Hub, those images are not returned as part of this action. Those images are not registered to your Lightsail container service.

    Args:
        service_name(str): The name of the container service for which to return registered container images.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.image.get_all(ctx, service_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.image.get_all service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_container_images",
        op_kwargs={"serviceName": service_name},
    )


async def register(hub, ctx, service_name: str, label: str, digest: str) -> Dict:
    r"""
    **Autogenerated function**

    Registers a container image to your Amazon Lightsail container service.  This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container images to your Lightsail container service. For more information, see Pushing and managing container images on your Amazon Lightsail container services in the Amazon Lightsail Developer Guide.

    Args:
        service_name(str): The name of the container service for which to register a container image.
        label(str): The label for the container image when it's registered to the container service. Use a descriptive label that you can use to track the different versions of your registered container images. Use the GetContainerImages action to return the container images registered to a Lightsail container service. The label is the <imagelabel> portion of the following image name example:    :container-service-1.<imagelabel>.1    If the name of your container service is mycontainerservice, and the label that you specify is mystaticwebsite, then the name of the registered container image will be :mycontainerservice.mystaticwebsite.1. The number at the end of these image name examples represents the version of the registered container image. If you push and register another container image to the same Lightsail container service, with the same label, then the version number for the new registered container image will be 2. If you push and register another container image, the version number will be 3, and so on.
        digest(str): The digest of the container image to be registered.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.image.register(
                ctx, service_name=value, label=value, digest=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.image.register service_name=value, label=value, digest=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="register_container_image",
        op_kwargs={"serviceName": service_name, "label": label, "digest": digest},
    )
