"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about Amazon Lightsail containers, such as the current version of the Lightsail Control (lightsailctl) plugin.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.api_metadata.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.api_metadata.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_container_api_metadata",
        op_kwargs={},
    )
