"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(hub, ctx, protocol: str) -> Dict:
    r"""
    **Autogenerated function**

    Sends a verification request to an email contact method to ensure it's owned by the requester. SMS contact methods don't need to be verified. A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more information, see Notifications in Amazon Lightsail. A verification request is sent to the contact method when you initially create it. Use this action to send another verification request if a previous verification request was deleted, or has expired.  Notifications are not sent to an email contact method until after it is verified, and confirmed as valid.

    Args:
        protocol(str): The protocol to verify, such as Email or SMS (text messaging).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.contact_method.verification.send(ctx, protocol=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.contact_method.verification.send protocol=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="send_contact_method_verification",
        op_kwargs={"protocol": protocol},
    )
