"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    certificate_name: str,
    domain_name: str,
    subject_alternative_names: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network (CDN) distribution and a container service. After the certificate is valid, use the AttachCertificateToDistribution action to use the certificate and its domains with your distribution. Or use the UpdateContainerService action to use the certificate and its domains with your container service.  Only certificates created in the us-east-1 AWS Region can be attached to Lightsail distributions. Lightsail distributions are global resources that can reference an origin in any AWS Region, and distribute its content globally. However, all distributions are located in the us-east-1 Region.

    Args:
        certificate_name(str): The name for the certificate.
        domain_name(str): The domain name (e.g., example.com) for the certificate.
        subject_alternative_names(List, optional): An array of strings that specify the alternate domains (e.g., example2.com) and subdomains (e.g., blog.example.com) for the certificate. You can specify a maximum of nine alternate domains (in addition to the primary domain name). Wildcard domain entries (e.g., *.example.com) are not supported. Defaults to None.
        tags(List, optional): The tag keys and optional values to add to the certificate during create. Use the TagResource action to tag a resource after it's created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.certificate.init.create(
                ctx, certificate_name=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.certificate.init.create certificate_name=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_certificate",
        op_kwargs={
            "certificateName": certificate_name,
            "domainName": domain_name,
            "subjectAlternativeNames": subject_alternative_names,
            "tags": tags,
        },
    )


async def delete(hub, ctx, certificate_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN) distribution. Certificates that are currently attached to a distribution cannot be deleted. Use the DetachCertificateFromDistribution action to detach a certificate from a distribution.

    Args:
        certificate_name(str): The name of the certificate to delete. Use the GetCertificates action to get a list of certificate names that you can specify.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.certificate.init.delete(ctx, certificate_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.certificate.init.delete certificate_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_certificate",
        op_kwargs={"certificateName": certificate_name},
    )


async def get_all(
    hub,
    ctx,
    certificate_statuses: List = None,
    include_certificate_details: bool = None,
    certificate_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about one or more Amazon Lightsail SSL/TLS certificates.  To get a summary of a certificate, ommit includeCertificateDetails from your request. The response will include only the certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.

    Args:
        certificate_statuses(List, optional): The status of the certificates for which to return information. For example, specify ISSUED to return only certificates with an ISSUED status. When omitted, the response includes all of your certificates in the AWS Region where the request is made, regardless of their current status. Defaults to None.
        include_certificate_details(bool, optional): Indicates whether to include detailed information about the certificates in the response. When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain names, and tags. Defaults to None.
        certificate_name(str, optional): The name for the certificate for which to return information. When omitted, the response includes all of your certificates in the AWS Region where the request is made. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.certificate.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.certificate.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_certificates",
        op_kwargs={
            "certificateStatuses": certificate_statuses,
            "includeCertificateDetails": include_certificate_details,
            "certificateName": certificate_name,
        },
    )
