"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, include_inactive: bool = None, page_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual private server (or instance).

    Args:
        include_inactive(bool, optional): A Boolean value that indicates whether to include inactive bundle results in your request. Defaults to None.
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetBundles request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bundle.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bundle.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_bundles",
        op_kwargs={"includeInactive": include_inactive, "pageToken": page_token},
    )
