"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    bucket_name: str,
    metric_name: str,
    start_time: str,
    end_time: str,
    period: int,
    statistics: List,
    unit: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the data points of a specific metric for an Amazon Lightsail bucket. Metrics report the utilization of a bucket. View and collect metric data regularly to monitor the number of objects stored in a bucket (including object versions) and the storage space used by those objects.

    Args:
        bucket_name(str): The name of the bucket for which to get metric data.
        metric_name(str): The metric for which you want to return information. Valid bucket metric names are listed below, along with the most useful statistics to include in your request, and the published unit value.  These bucket metrics are reported once per day.      BucketSizeBytes  - The amount of data in bytes stored in a bucket. This value is calculated by summing the size of all objects in the bucket (including object versions), including the size of all parts for all incomplete multipart uploads to the bucket. Statistics: The most useful statistic is Maximum. Unit: The published unit is Bytes.     NumberOfObjects  - The total number of objects stored in a bucket. This value is calculated by counting all objects in the bucket (including object versions) and the total number of parts for all incomplete multipart uploads to the bucket. Statistics: The most useful statistic is Average. Unit: The published unit is Count.  .
        start_time(str): The timestamp indicating the earliest data to be returned.
        end_time(str): The timestamp indicating the latest data to be returned.
        period(int): The granularity, in seconds, of the returned data points.  Bucket storage metrics are reported once per day. Therefore, you should specify a period of 86400 seconds, which is the number of seconds in a day. .
        statistics(List): The statistic for the metric. The following statistics are available:    Minimum - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.    Maximum - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.    Sum - The sum of all values submitted for the matching metric. You can use this statistic to determine the total volume of a metric.    Average - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.    SampleCount - The count, or number, of data points used for the statistical calculation.  .
        unit(str): The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units with each available metric, see the metricName parameter.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bucket.metric_data.get(
                ctx,
                bucket_name=value,
                metric_name=value,
                start_time=value,
                end_time=value,
                period=value,
                statistics=value,
                unit=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bucket.metric_data.get bucket_name=value, metric_name=value, start_time=value, end_time=value, period=value, statistics=value, unit=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_bucket_metric_data",
        op_kwargs={
            "bucketName": bucket_name,
            "metricName": metric_name,
            "startTime": start_time,
            "endTime": end_time,
            "period": period,
            "statistics": statistics,
            "unit": unit,
        },
    )
