"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    bucket_name: str,
    bundle_id: str,
    tags: List = None,
    enable_object_versioning: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Lightsail bucket. A bucket is a cloud storage resource available in the Lightsail object storage service. Use buckets to store objects such as data and its descriptive metadata. For more information about buckets, see Buckets in Amazon Lightsail in the Amazon Lightsail Developer Guide.

    Args:
        bucket_name(str): The name for the bucket. For more information about bucket names, see Bucket naming rules in Amazon Lightsail in the Amazon Lightsail Developer Guide.
        bundle_id(str): The ID of the bundle to use for the bucket. A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket. Use the GetBucketBundles action to get a list of bundle IDs that you can specify. Use the UpdateBucketBundle action to change the bundle after the bucket is created.
        tags(List, optional): The tag keys and optional values to add to the bucket during creation. Use the TagResource action to tag the bucket after it's created. Defaults to None.
        enable_object_versioning(bool, optional): A Boolean value that indicates whether to enable versioning of objects in the bucket. For more information about versioning, see Enabling and suspending bucket object versioning in Amazon Lightsail in the Amazon Lightsail Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bucket.init.create(
                ctx, bucket_name=value, bundle_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bucket.init.create bucket_name=value, bundle_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_bucket",
        op_kwargs={
            "bucketName": bucket_name,
            "bundleId": bundle_id,
            "tags": tags,
            "enableObjectVersioning": enable_object_versioning,
        },
    )


async def delete(hub, ctx, bucket_name: str, force_delete: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Amazon Lightsail bucket.  When you delete your bucket, the bucket name is released and can be reused for a new bucket in your account or another AWS account.

    Args:
        bucket_name(str): The name of the bucket to delete. Use the GetBuckets action to get a list of bucket names that you can specify.
        force_delete(bool, optional): A Boolean value that indicates whether to force delete the bucket. You must force delete the bucket if it has one of the following conditions:   The bucket is the origin of a distribution.   The bucket has instances that were granted access to it using the SetResourceAccessForBucket action.   The bucket has objects.   The bucket has access keys.    Force deleting a bucket might impact other resources that rely on the bucket, such as instances, distributions, or software that use the issued access keys. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bucket.init.delete(ctx, bucket_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bucket.init.delete bucket_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_bucket",
        op_kwargs={"bucketName": bucket_name, "forceDelete": force_delete},
    )


async def get_all(
    hub,
    ctx,
    bucket_name: str = None,
    page_token: str = None,
    include_connected_resources: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about one or more Amazon Lightsail buckets. For more information about buckets, see Buckets in Amazon Lightsail in the Amazon Lightsail Developer Guide..

    Args:
        bucket_name(str, optional): The name of the bucket for which to return information. When omitted, the response includes all of your buckets in the AWS Region where the request is made. Defaults to None.
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetBuckets request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.
        include_connected_resources(bool, optional): A Boolean value that indicates whether to include Lightsail instances that were given access to the bucket using the SetResourceAccessForBucket action. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bucket.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bucket.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_buckets",
        op_kwargs={
            "bucketName": bucket_name,
            "pageToken": page_token,
            "includeConnectedResources": include_connected_resources,
        },
    )


async def update(
    hub,
    ctx,
    bucket_name: str,
    access_rules: Dict = None,
    versioning: str = None,
    readonly_access_accounts: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing Amazon Lightsail bucket. Use this action to update the configuration of an existing bucket, such as versioning, public accessibility, and the AWS accounts that can access the bucket.

    Args:
        bucket_name(str): The name of the bucket to update.
        access_rules(Dict, optional): An object that sets the public accessibility of objects in the specified bucket. Defaults to None.
        versioning(str, optional): Specifies whether to enable or suspend versioning of objects in the bucket. The following options can be specified:    Enabled - Enables versioning of objects in the specified bucket.    Suspended - Suspends versioning of objects in the specified bucket. Existing object versions are retained.  . Defaults to None.
        readonly_access_accounts(List, optional): An array of strings to specify the AWS account IDs that can access the bucket. You can give a maximum of 10 AWS accounts access to a bucket. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bucket.init.update(ctx, bucket_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bucket.init.update bucket_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="update_bucket",
        op_kwargs={
            "bucketName": bucket_name,
            "accessRules": access_rules,
            "versioning": versioning,
            "readonlyAccessAccounts": readonly_access_accounts,
        },
    )
