"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, include_inactive: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the bundles that you can apply to a Amazon Lightsail bucket. The bucket bundle specifies the monthly cost, storage quota, and data transfer quota for a bucket. Use the UpdateBucketBundle action to update the bundle for a bucket.

    Args:
        include_inactive(bool, optional): A Boolean value that indicates whether to include inactive (unavailable) bundles in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bucket.bundle.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bucket.bundle.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_bucket_bundles",
        op_kwargs={"includeInactive": include_inactive},
    )


async def update(hub, ctx, bucket_name: str, bundle_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the bundle, or storage plan, of an existing Amazon Lightsail bucket. A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket. You can update a bucket's bundle only one time within a monthly AWS billing cycle. To determine if you can update a bucket's bundle, use the GetBuckets action. The ableToUpdateBundle parameter in the response will indicate whether you can currently update a bucket's bundle. Update a bucket's bundle if it's consistently going over its storage space or data transfer quota, or if a bucket's usage is consistently in the lower range of its storage space or data transfer quota. Due to the unpredictable usage fluctuations that a bucket might experience, we strongly recommend that you update a bucket's bundle only as a long-term strategy, instead of as a short-term, monthly cost-cutting measure. Choose a bucket bundle that will provide the bucket with ample storage space and data transfer for a long time to come.

    Args:
        bucket_name(str): The name of the bucket for which to update the bundle.
        bundle_id(str): The ID of the new bundle to apply to the bucket. Use the GetBucketBundles action to get a list of bundle IDs that you can specify.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bucket.bundle.update(
                ctx, bucket_name=value, bundle_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bucket.bundle.update bucket_name=value, bundle_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="update_bucket_bundle",
        op_kwargs={"bucketName": bucket_name, "bundleId": bundle_id},
    )
