"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, bucket_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new access key for the specified Amazon Lightsail bucket. Access keys consist of an access key ID and corresponding secret access key. Access keys grant full programmatic access to the specified bucket and its objects. You can have a maximum of two access keys per bucket. Use the GetBucketAccessKeys action to get a list of current access keys for a specific bucket. For more information about access keys, see Creating access keys for a bucket in Amazon Lightsail in the Amazon Lightsail Developer Guide.  The secretAccessKey value is returned only in response to the CreateBucketAccessKey action. You can get a secret access key only when you first create an access key; you cannot get the secret access key later. If you lose the secret access key, you must create a new access key.

    Args:
        bucket_name(str): The name of the bucket that the new access key will belong to, and grant access to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bucket.access_key.create(ctx, bucket_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bucket.access_key.create bucket_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_bucket_access_key",
        op_kwargs={"bucketName": bucket_name},
    )


async def delete(hub, ctx, bucket_name: str, access_key_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an access key for the specified Amazon Lightsail bucket. We recommend that you delete an access key if the secret access key is compromised. For more information about access keys, see Creating access keys for a bucket in Amazon Lightsail in the Amazon Lightsail Developer Guide.

    Args:
        bucket_name(str): The name of the bucket that the access key belongs to.
        access_key_id(str): The ID of the access key to delete. Use the GetBucketAccessKeys action to get a list of access key IDs that you can specify.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bucket.access_key.delete(
                ctx, bucket_name=value, access_key_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bucket.access_key.delete bucket_name=value, access_key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_bucket_access_key",
        op_kwargs={"bucketName": bucket_name, "accessKeyId": access_key_id},
    )


async def get_all(hub, ctx, bucket_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the existing access key IDs for the specified Amazon Lightsail bucket.  This action does not return the secret access key value of an access key. You can get a secret access key only when you create it from the response of the CreateBucketAccessKey action. If you lose the secret access key, you must create a new access key.

    Args:
        bucket_name(str): The name of the bucket for which to return access keys.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.bucket.access_key.get_all(ctx, bucket_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.bucket.access_key.get_all bucket_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_bucket_access_keys",
        op_kwargs={"bucketName": bucket_name},
    )
