"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, include_inactive: bool = None, page_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of available instance images, or blueprints. You can use a blueprint to create a new instance already running a specific operating system, as well as a preinstalled app or development stack. The software each instance is running depends on the blueprint image you choose.  Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.

    Args:
        include_inactive(bool, optional): A Boolean value indicating whether to include inactive results in your request. Defaults to None.
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetBlueprints request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.blueprint.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.blueprint.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_blueprints",
        op_kwargs={"includeInactive": include_inactive, "pageToken": page_token},
    )
