"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, alarm_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an alarm. An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see Alarms in Amazon Lightsail.

    Args:
        alarm_name(str): The name of the alarm to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.alarm.delete(ctx, alarm_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.alarm.delete alarm_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_alarm",
        op_kwargs={"alarmName": alarm_name},
    )


async def get_all(
    hub,
    ctx,
    alarm_name: str = None,
    page_token: str = None,
    monitored_resource_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the configured alarms. Specify an alarm name in your request to return information about a specific alarm, or specify a monitored resource name to return information about all alarms for a specific resource. An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see Alarms in Amazon Lightsail.

    Args:
        alarm_name(str, optional): The name of the alarm. Specify an alarm name to return information about a specific alarm. Defaults to None.
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetAlarms request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.
        monitored_resource_name(str, optional): The name of the Lightsail resource being monitored by the alarm. Specify a monitored resource name to return information about all alarms for a specific resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.alarm.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.alarm.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_alarms",
        op_kwargs={
            "alarmName": alarm_name,
            "pageToken": page_token,
            "monitoredResourceName": monitored_resource_name,
        },
    )


async def put(
    hub,
    ctx,
    alarm_name: str,
    metric_name: str,
    monitored_resource_name: str,
    comparison_operator: str,
    threshold: float,
    evaluation_periods: int,
    datapoints_to_alarm: int = None,
    treat_missing_data: str = None,
    contact_protocols: List = None,
    notification_triggers: List = None,
    notification_enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates an alarm, and associates it with the specified metric. An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see Alarms in Amazon Lightsail. When this action creates an alarm, the alarm state is immediately set to INSUFFICIENT_DATA. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed. When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm. The alarm is then evaluated with the updated configuration.

    Args:
        alarm_name(str): The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous configuration of the alarm.
        metric_name(str): The name of the metric to associate with the alarm. You can configure up to two alarms per metric. The following metrics are available for each resource type:    Instances: BurstCapacityPercentage, BurstCapacityTime, CPUUtilization, NetworkIn, NetworkOut, StatusCheckFailed, StatusCheckFailed_Instance, and StatusCheckFailed_System.    Load balancers: ClientTLSNegotiationErrorCount, HealthyHostCount, UnhealthyHostCount, HTTPCode_LB_4XX_Count, HTTPCode_LB_5XX_Count, HTTPCode_Instance_2XX_Count, HTTPCode_Instance_3XX_Count, HTTPCode_Instance_4XX_Count, HTTPCode_Instance_5XX_Count, InstanceResponseTime, RejectedConnectionCount, and RequestCount.    Relational databases: CPUUtilization, DatabaseConnections, DiskQueueDepth, FreeStorageSpace, NetworkReceiveThroughput, and NetworkTransmitThroughput.   For more information about these metrics, see Metrics available in Lightsail.
        monitored_resource_name(str): The name of the Lightsail resource that will be monitored. Instances, load balancers, and relational databases are the only Lightsail resources that can currently be monitored by alarms.
        comparison_operator(str): The arithmetic operation to use when comparing the specified statistic to the threshold. The specified statistic value is used as the first operand.
        threshold(float): The value against which the specified statistic is compared.
        evaluation_periods(int): The number of most recent periods over which data is compared to the specified threshold. If you are setting an "M out of N" alarm, this value (evaluationPeriods) is the N. If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger the alarm, this value specifies the rolling period of time in which data points are evaluated. Each evaluation period is five minutes long. For example, specify an evaluation period of 24 to evaluate a metric over a rolling period of two hours. You can specify a minimum valuation period of 1 (5 minutes), and a maximum evaluation period of 288 (24 hours).
        datapoints_to_alarm(int, optional): The number of data points that must be not within the specified threshold to trigger the alarm. If you are setting an "M out of N" alarm, this value (datapointsToAlarm) is the M. Defaults to None.
        treat_missing_data(str, optional): Sets how this alarm will handle missing data points. An alarm can treat missing data in the following ways:    breaching - Assume the missing data is not within the threshold. Missing data counts towards the number of times the metric is not within the threshold.    notBreaching - Assume the missing data is within the threshold. Missing data does not count towards the number of times the metric is not within the threshold.    ignore - Ignore the missing data. Maintains the current alarm state.    missing - Missing data is treated as missing.   If treatMissingData is not specified, the default behavior of missing is used. Defaults to None.
        contact_protocols(List, optional): The contact protocols to use for the alarm, such as Email, SMS (text messaging), or both. A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and when the alarm is triggered. A notification is not sent if a contact protocol is not specified, if the specified contact protocol is not configured in the AWS Region, or if notifications are not enabled for the alarm using the notificationEnabled paramater. Use the CreateContactMethod action to configure a contact protocol in an AWS Region. Defaults to None.
        notification_triggers(List, optional): The alarm states that trigger a notification. An alarm has the following possible states:    ALARM - The metric is outside of the defined threshold.    INSUFFICIENT_DATA - The alarm has just started, the metric is not available, or not enough data is available for the metric to determine the alarm state.    OK - The metric is within the defined threshold.   When you specify a notification trigger, the ALARM state must be specified. The INSUFFICIENT_DATA and OK states can be specified in addition to the ALARM state.   If you specify OK as an alarm trigger, a notification is sent when the alarm switches from an ALARM or INSUFFICIENT_DATA alarm state to an OK state. This can be thought of as an all clear alarm notification.   If you specify INSUFFICIENT_DATA as the alarm trigger, a notification is sent when the alarm switches from an OK or ALARM alarm state to an INSUFFICIENT_DATA state.   The notification trigger defaults to ALARM if you don't specify this parameter. Defaults to None.
        notification_enabled(bool, optional): Indicates whether the alarm is enabled. Notifications are enabled by default if you don't specify this parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.alarm.put(
                ctx,
                alarm_name=value,
                metric_name=value,
                monitored_resource_name=value,
                comparison_operator=value,
                threshold=value,
                evaluation_periods=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.alarm.put alarm_name=value, metric_name=value, monitored_resource_name=value, comparison_operator=value, threshold=value, evaluation_periods=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="put_alarm",
        op_kwargs={
            "alarmName": alarm_name,
            "metricName": metric_name,
            "monitoredResourceName": monitored_resource_name,
            "comparisonOperator": comparison_operator,
            "threshold": threshold,
            "evaluationPeriods": evaluation_periods,
            "datapointsToAlarm": datapoints_to_alarm,
            "treatMissingData": treat_missing_data,
            "contactProtocols": contact_protocols,
            "notificationTriggers": notification_triggers,
            "notificationEnabled": notification_enabled,
        },
    )


async def test(hub, ctx, alarm_name: str, state: str) -> Dict:
    r"""
    **Autogenerated function**

    Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification trigger is configured for the specified alarm, the test also sends a notification to the notification protocol (Email and/or SMS) configured for the alarm. An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more information, see Alarms in Amazon Lightsail.

    Args:
        alarm_name(str): The name of the alarm to test.
        state(str): The alarm state to test. An alarm has the following possible states that can be tested:    ALARM - The metric is outside of the defined threshold.    INSUFFICIENT_DATA - The alarm has just started, the metric is not available, or not enough data is available for the metric to determine the alarm state.    OK - The metric is within the defined threshold.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.alarm.test(ctx, alarm_name=value, state=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.alarm.test alarm_name=value, state=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="test_alarm",
        op_kwargs={"alarmName": alarm_name, "state": state},
    )
