"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, add_on_type: str, resource_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables an add-on for an Amazon Lightsail resource. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        add_on_type(str): The add-on type to disable.
        resource_name(str): The name of the source resource for which to disable the add-on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.add_on.disable(
                ctx, add_on_type=value, resource_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.add_on.disable add_on_type=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="disable_add_on",
        op_kwargs={"addOnType": add_on_type, "resourceName": resource_name},
    )


async def enable(hub, ctx, resource_name: str, add_on_request: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        resource_name(str): The name of the source resource for which to enable or modify the add-on.
        add_on_request(Dict): An array of strings representing the add-on to enable or modify.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.add_on.enable(
                ctx, resource_name=value, add_on_request=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.add_on.enable resource_name=value, add_on_request=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="enable_add_on",
        op_kwargs={"resourceName": resource_name, "addOnRequest": add_on_request},
    )
