"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    license_arn: str,
    client_token: str,
    role_arns: List = None,
    expiration_in_days: int = None,
    token_properties: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a long-lived token. A refresh token is a JWT token used to get an access token. With an access token, you can call AssumeRoleWithWebIdentity to get role credentials that you can use to call License Manager to manage the specified license.

    Args:
        license_arn(str): Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.
        role_arns(List, optional): Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the roles are in use. Defaults to None.
        expiration_in_days(int, optional): Token expiration, in days, counted from token creation. The default is 365 days. Defaults to None.
        token_properties(List, optional): Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT token. Defaults to None.
        client_token(str): Idempotency token, valid for 10 minutes.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.token.create(
                ctx, license_arn=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.token.create license_arn=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="create_token",
        op_kwargs={
            "LicenseArn": license_arn,
            "RoleArns": role_arns,
            "ExpirationInDays": expiration_in_days,
            "TokenProperties": token_properties,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, token_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified token. Must be called in the license home Region.

    Args:
        token_id(str): Token ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.token.delete(ctx, token_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.token.delete token_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="delete_token",
        op_kwargs={"TokenId": token_id},
    )


async def list_all(
    hub,
    ctx,
    token_ids: List = None,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists your tokens.

    Args:
        token_ids(List, optional): Token IDs. Defaults to None.
        filters(List, optional): Filters to scope the results. The following filter is supported:    LicenseArns   . Defaults to None.
        next_token(str, optional): Token for the next set of results. Defaults to None.
        max_results(int, optional): Maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.token.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.token.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="list_tokens",
        op_kwargs={
            "TokenIds": token_ids,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
