"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gets the License Manager settings for the current Region.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.service_setting.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.service_setting.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="get_service_settings",
        op_kwargs={},
    )


async def update_multiple(
    hub,
    ctx,
    s3_bucket_arn: str = None,
    sns_topic_arn: str = None,
    organization_configuration: Dict = None,
    enable_cross_accounts_discovery: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates License Manager settings for the current Region.

    Args:
        s3_bucket_arn(str, optional): Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored. Defaults to None.
        sns_topic_arn(str, optional): Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts. Defaults to None.
        organization_configuration(Dict, optional): Enables integration with AWS Organizations for cross-account discovery. Defaults to None.
        enable_cross_accounts_discovery(bool, optional): Activates cross-account discovery. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.service_setting.update_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.service_setting.update_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="update_service_settings",
        op_kwargs={
            "S3BucketArn": s3_bucket_arn,
            "SnsTopicArn": sns_topic_arn,
            "OrganizationConfiguration": organization_configuration,
            "EnableCrossAccountsDiscovery": enable_cross_accounts_discovery,
        },
    )
