"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    license_arn: str,
    license_name: str,
    product_name: str,
    issuer: Dict,
    home_region: str,
    validity: Dict,
    entitlements: List,
    consumption_configuration: Dict,
    status: str,
    client_token: str,
    license_metadata: List = None,
    source_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version of the specified license.

    Args:
        license_arn(str): Amazon Resource Name (ARN) of the license.
        license_name(str): License name.
        product_name(str): Product name.
        issuer(Dict): License issuer.
        home_region(str): Home Region of the license.
        validity(Dict): Date and time range during which the license is valid, in ISO8601-UTC format.
        license_metadata(List, optional): Information about the license. Defaults to None.
        entitlements(List): License entitlements.
        consumption_configuration(Dict): Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.
        status(str): License status.
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        source_version(str, optional): Current version of the license. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.version.create(
                ctx,
                license_arn=value,
                license_name=value,
                product_name=value,
                issuer=value,
                home_region=value,
                validity=value,
                entitlements=value,
                consumption_configuration=value,
                status=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.version.create license_arn=value, license_name=value, product_name=value, issuer=value, home_region=value, validity=value, entitlements=value, consumption_configuration=value, status=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="create_license_version",
        op_kwargs={
            "LicenseArn": license_arn,
            "LicenseName": license_name,
            "ProductName": product_name,
            "Issuer": issuer,
            "HomeRegion": home_region,
            "Validity": validity,
            "LicenseMetadata": license_metadata,
            "Entitlements": entitlements,
            "ConsumptionConfiguration": consumption_configuration,
            "Status": status,
            "ClientToken": client_token,
            "SourceVersion": source_version,
        },
    )


async def list_all(
    hub, ctx, license_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all versions of the specified license.

    Args:
        license_arn(str): Amazon Resource Name (ARN) of the license.
        next_token(str, optional): Token for the next set of results. Defaults to None.
        max_results(int, optional): Maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.version.list_all(
                ctx, license_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.version.list_all license_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="list_license_versions",
        op_kwargs={
            "LicenseArn": license_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
