"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, license_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets detailed information about the usage of the specified license.

    Args:
        license_arn(str): Amazon Resource Name (ARN) of the license.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.usage.get(ctx, license_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.usage.get license_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="get_license_usage",
        op_kwargs={"LicenseArn": license_arn},
    )
