"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the license configurations for the specified resource.

    Args:
        resource_arn(str): Amazon Resource Name (ARN) of a resource that has an associated license configuration.
        max_results(int, optional): Maximum number of results to return in a single call. Defaults to None.
        next_token(str, optional): Token for the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.specification_for_resource.list(
                ctx, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.specification_for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="list_license_specifications_for_resource",
        op_kwargs={
            "ResourceArn": resource_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    resource_arn: str,
    add_license_specifications: List = None,
    remove_license_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds or removes the specified license configurations for the specified AWS resource. You can update the license specifications of AMIs, instances, and hosts. You cannot update the license specifications for launch templates and AWS CloudFormation templates, as they send license configurations to the operation that creates the resource.

    Args:
        resource_arn(str): Amazon Resource Name (ARN) of the AWS resource.
        add_license_specifications(List, optional): ARNs of the license configurations to add. Defaults to None.
        remove_license_specifications(List, optional): ARNs of the license configurations to remove. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.specification_for_resource.update(
                ctx, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.specification_for_resource.update resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="update_license_specifications_for_resource",
        op_kwargs={
            "ResourceArn": resource_arn,
            "AddLicenseSpecifications": add_license_specifications,
            "RemoveLicenseSpecifications": remove_license_specifications,
        },
    )
