"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    report_generator_name: str,
    type_: List,
    report_context: Dict,
    report_frequency: Dict,
    client_token: str,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new report generator.

    Args:
        report_generator_name(str): Name of the report generator.
        type_(List): Type of reports to generate. The following report types an be generated:   License configuration report - Reports on the number and details of consumed licenses for a license configuration.   Resource report - Reports on the tracked licenses and resource consumption for a license configuration.  .
        report_context(Dict): Defines the type of license configuration the report generator tracks.
        report_frequency(Dict): Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        description(str, optional): Description of the report generator. Defaults to None.
        tags(List, optional): Tags to add to the report generator. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.manager_report_generator.create(
                ctx,
                report_generator_name=value,
                type_=value,
                report_context=value,
                report_frequency=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.manager_report_generator.create report_generator_name=value, type_=value, report_context=value, report_frequency=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="create_license_manager_report_generator",
        op_kwargs={
            "ReportGeneratorName": report_generator_name,
            "Type": type_,
            "ReportContext": report_context,
            "ReportFrequency": report_frequency,
            "ClientToken": client_token,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, license_manager_report_generator_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete an existing report generator. This action deletes the report generator, which stops it from generating future reports and cannot be reversed. However, the previous reports from this generator will remain in your S3 bucket.

    Args:
        license_manager_report_generator_arn(str): Amazon Resource Number (ARN) of the report generator that will be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.manager_report_generator.delete(
                ctx, license_manager_report_generator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.manager_report_generator.delete license_manager_report_generator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="delete_license_manager_report_generator",
        op_kwargs={
            "LicenseManagerReportGeneratorArn": license_manager_report_generator_arn
        },
    )


async def get(hub, ctx, license_manager_report_generator_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information on the specified report generator.

    Args:
        license_manager_report_generator_arn(str): mazon Resource Number (ARN) of the report generator to retrieve information on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.manager_report_generator.get(
                ctx, license_manager_report_generator_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.manager_report_generator.get license_manager_report_generator_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="get_license_manager_report_generator",
        op_kwargs={
            "LicenseManagerReportGeneratorArn": license_manager_report_generator_arn
        },
    )


async def list_all(
    hub, ctx, filters: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the report generators for your account.

    Args:
        filters(List, optional): Filters to scope the results. The following filters are supported:     LicenseConfigurationArn   . Defaults to None.
        next_token(str, optional): Token for the next set of results. Defaults to None.
        max_results(int, optional): Maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.manager_report_generator.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.manager_report_generator.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="list_license_manager_report_generators",
        op_kwargs={
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    license_manager_report_generator_arn: str,
    report_generator_name: str,
    type_: List,
    report_context: Dict,
    report_frequency: Dict,
    client_token: str,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a report generator. After you make changes to a report generator, it will start generating new reports within 60 minutes of being updated.

    Args:
        license_manager_report_generator_arn(str): Amazon Resource Number (ARN) of the report generator to update.
        report_generator_name(str): Name of the report generator.
        type_(List): Type of reports to generate. The following report types an be generated:   License configuration report - Reports on the number and details of consumed licenses for a license configuration.   Resource report - Reports on the tracked licenses and resource consumption for a license configuration.  .
        report_context(Dict): ?.
        report_frequency(Dict): Frequency by which reports are generated. The following options are avaiable: ??? What are the APi value options?.
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        description(str, optional): Description of the report generator. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.manager_report_generator.update(
                ctx,
                license_manager_report_generator_arn=value,
                report_generator_name=value,
                type_=value,
                report_context=value,
                report_frequency=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.manager_report_generator.update license_manager_report_generator_arn=value, report_generator_name=value, type_=value, report_context=value, report_frequency=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="update_license_manager_report_generator",
        op_kwargs={
            "LicenseManagerReportGeneratorArn": license_manager_report_generator_arn,
            "ReportGeneratorName": report_generator_name,
            "Type": type_,
            "ReportContext": report_context,
            "ReportFrequency": report_frequency,
            "ClientToken": client_token,
            "Description": description,
        },
    )
