"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def checkout(
    hub,
    ctx,
    product_sku: str,
    checkout_type: str,
    key_fingerprint: str,
    entitlements: List,
    client_token: str,
    beneficiary: str = None,
    node_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Checks out the specified license.

    Args:
        product_sku(str): Product SKU.
        checkout_type(str): Checkout type.
        key_fingerprint(str): Key fingerprint identifying the license.
        entitlements(List): License entitlements.
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        beneficiary(str, optional): License beneficiary. Defaults to None.
        node_id(str, optional): Node ID. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.init.checkout(
                ctx,
                product_sku=value,
                checkout_type=value,
                key_fingerprint=value,
                entitlements=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.init.checkout product_sku=value, checkout_type=value, key_fingerprint=value, entitlements=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="checkout_license",
        op_kwargs={
            "ProductSKU": product_sku,
            "CheckoutType": checkout_type,
            "KeyFingerprint": key_fingerprint,
            "Entitlements": entitlements,
            "ClientToken": client_token,
            "Beneficiary": beneficiary,
            "NodeId": node_id,
        },
    )


async def create(
    hub,
    ctx,
    license_name: str,
    product_name: str,
    product_sku: str,
    issuer: Dict,
    home_region: str,
    validity: Dict,
    entitlements: List,
    beneficiary: str,
    consumption_configuration: Dict,
    client_token: str,
    license_metadata: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a license.

    Args:
        license_name(str): License name.
        product_name(str): Product name.
        product_sku(str): Product SKU.
        issuer(Dict): License issuer.
        home_region(str): Home Region for the license.
        validity(Dict): Date and time range during which the license is valid, in ISO8601-UTC format.
        entitlements(List): License entitlements.
        beneficiary(str): License beneficiary.
        consumption_configuration(Dict): Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.
        license_metadata(List, optional): Information about the license. Defaults to None.
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.init.create(
                ctx,
                license_name=value,
                product_name=value,
                product_sku=value,
                issuer=value,
                home_region=value,
                validity=value,
                entitlements=value,
                beneficiary=value,
                consumption_configuration=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.init.create license_name=value, product_name=value, product_sku=value, issuer=value, home_region=value, validity=value, entitlements=value, beneficiary=value, consumption_configuration=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="create_license",
        op_kwargs={
            "LicenseName": license_name,
            "ProductName": product_name,
            "ProductSKU": product_sku,
            "Issuer": issuer,
            "HomeRegion": home_region,
            "Validity": validity,
            "Entitlements": entitlements,
            "Beneficiary": beneficiary,
            "ConsumptionConfiguration": consumption_configuration,
            "LicenseMetadata": license_metadata,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, license_arn: str, source_version: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified license.

    Args:
        license_arn(str): Amazon Resource Name (ARN) of the license.
        source_version(str): Current version of the license.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.init.delete(
                ctx, license_arn=value, source_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.init.delete license_arn=value, source_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="delete_license",
        op_kwargs={"LicenseArn": license_arn, "SourceVersion": source_version},
    )


async def get(hub, ctx, license_arn: str, version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets detailed information about the specified license.

    Args:
        license_arn(str): Amazon Resource Name (ARN) of the license.
        version(str, optional): License version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.init.get(ctx, license_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.init.get license_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="get_license",
        op_kwargs={"LicenseArn": license_arn, "Version": version},
    )


async def list_all(
    hub,
    ctx,
    license_arns: List = None,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the licenses for your account.

    Args:
        license_arns(List, optional): Amazon Resource Names (ARNs) of the licenses. Defaults to None.
        filters(List, optional): Filters to scope the results. The following filters are supported:    Beneficiary     ProductSKU     Fingerprint     Status   . Defaults to None.
        next_token(str, optional): Token for the next set of results. Defaults to None.
        max_results(int, optional): Maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="list_licenses",
        op_kwargs={
            "LicenseArns": license_arns,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
