"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def extend(
    hub, ctx, license_consumption_token: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Extends the expiration date for license consumption.

    Args:
        license_consumption_token(str): License consumption token.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.license_.consumption.extend(
                ctx, license_consumption_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.license_.consumption.extend license_consumption_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="extend_license_consumption",
        op_kwargs={
            "LicenseConsumptionToken": license_consumption_token,
            "DryRun": dry_run,
        },
    )
