"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "in_license"


async def check(
    hub, ctx, license_consumption_token: str, beneficiary: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Checks in the specified license. Check in a license when it is no longer in use.

    Args:
        license_consumption_token(str): License consumption token.
        beneficiary(str, optional): License beneficiary. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.in_license_.check(
                ctx, license_consumption_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.in_license.check license_consumption_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="check_in_license",
        op_kwargs={
            "LicenseConsumptionToken": license_consumption_token,
            "Beneficiary": beneficiary,
        },
    )
