"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_token: str,
    grant_arn: str,
    grant_name: str = None,
    allowed_operations: List = None,
    status: str = None,
    status_reason: str = None,
    source_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version of the specified grant.

    Args:
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        grant_arn(str): Amazon Resource Name (ARN) of the grant.
        grant_name(str, optional): Grant name. Defaults to None.
        allowed_operations(List, optional): Allowed operations for the grant. Defaults to None.
        status(str, optional): Grant status. Defaults to None.
        status_reason(str, optional): . Defaults to None.
        source_version(str, optional): Current version of the grant. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.grant.version.create(
                ctx, client_token=value, grant_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.grant.version.create client_token=value, grant_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="create_grant_version",
        op_kwargs={
            "ClientToken": client_token,
            "GrantArn": grant_arn,
            "GrantName": grant_name,
            "AllowedOperations": allowed_operations,
            "Status": status,
            "StatusReason": status_reason,
            "SourceVersion": source_version,
        },
    )
