"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(hub, ctx, grant_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Accepts the specified grant.

    Args:
        grant_arn(str): Amazon Resource Name (ARN) of the grant.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.grant.init.accept(ctx, grant_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.grant.init.accept grant_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="accept_grant",
        op_kwargs={"GrantArn": grant_arn},
    )


async def create(
    hub,
    ctx,
    client_token: str,
    grant_name: str,
    license_arn: str,
    principals: List,
    home_region: str,
    allowed_operations: List,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a grant for the specified license. A grant shares the use of license entitlements with specific AWS accounts.

    Args:
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        grant_name(str): Grant name.
        license_arn(str): Amazon Resource Name (ARN) of the license.
        principals(List): The grant principals.
        home_region(str): Home Region of the grant.
        allowed_operations(List): Allowed operations for the grant.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.grant.init.create(
                ctx,
                client_token=value,
                grant_name=value,
                license_arn=value,
                principals=value,
                home_region=value,
                allowed_operations=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.grant.init.create client_token=value, grant_name=value, license_arn=value, principals=value, home_region=value, allowed_operations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="create_grant",
        op_kwargs={
            "ClientToken": client_token,
            "GrantName": grant_name,
            "LicenseArn": license_arn,
            "Principals": principals,
            "HomeRegion": home_region,
            "AllowedOperations": allowed_operations,
        },
    )


async def delete(
    hub, ctx, grant_arn: str, version: str, status_reason: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified grant.

    Args:
        grant_arn(str): Amazon Resource Name (ARN) of the grant.
        status_reason(str, optional): . Defaults to None.
        version(str): Current version of the grant.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.grant.init.delete(
                ctx, grant_arn=value, version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.grant.init.delete grant_arn=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="delete_grant",
        op_kwargs={
            "GrantArn": grant_arn,
            "StatusReason": status_reason,
            "Version": version,
        },
    )


async def get(hub, ctx, grant_arn: str, version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets detailed information about the specified grant.

    Args:
        grant_arn(str): Amazon Resource Name (ARN) of the grant.
        version(str, optional): Grant version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.grant.init.get(ctx, grant_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.grant.init.get grant_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="get_grant",
        op_kwargs={"GrantArn": grant_arn, "Version": version},
    )


async def reject(hub, ctx, grant_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Rejects the specified grant.

    Args:
        grant_arn(str): Amazon Resource Name (ARN) of the grant.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.grant.init.reject(ctx, grant_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.grant.init.reject grant_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="reject_grant",
        op_kwargs={"GrantArn": grant_arn},
    )
