"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    license_configuration_arn: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the license configuration operations that failed.

    Args:
        license_configuration_arn(str): Amazon Resource Name of the license configuration.
        max_results(int, optional): Maximum number of results to return in a single call. Defaults to None.
        next_token(str, optional): Token for the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.failure_for_license_configuration_operation.list_all(
                ctx, license_configuration_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.failure_for_license_configuration_operation.list_all license_configuration_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="list_failures_for_license_configuration_operations",
        op_kwargs={
            "LicenseConfigurationArn": license_configuration_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
