"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    grant_arns: List = None,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the grants distributed for the specified license.

    Args:
        grant_arns(List, optional): Amazon Resource Names (ARNs) of the grants. Defaults to None.
        filters(List, optional): Filters to scope the results. The following filters are supported:    LicenseArn     GrantStatus     GranteePrincipalARN     ProductSKU     LicenseIssuerName   . Defaults to None.
        next_token(str, optional): Token for the next set of results. Defaults to None.
        max_results(int, optional): Maximum number of results to return in a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.distributed_grant.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.distributed_grant.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="list_distributed_grants",
        op_kwargs={
            "GrantArns": grant_arns,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
