"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "borrow_license"


async def checkout(
    hub,
    ctx,
    license_arn: str,
    entitlements: List,
    digital_signature_method: str,
    client_token: str,
    node_id: str = None,
    checkout_metadata: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Checks out the specified license for offline use.

    Args:
        license_arn(str): Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.
        entitlements(List): License entitlements. Partial checkouts are not supported.
        digital_signature_method(str): Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information, see RFC 7518 Digital Signature with RSASSA-PSS.
        node_id(str, optional): Node ID. Defaults to None.
        checkout_metadata(List, optional): Information about constraints. Defaults to None.
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.borrow_license_.checkout(
                ctx,
                license_arn=value,
                entitlements=value,
                digital_signature_method=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.borrow_license.checkout license_arn=value, entitlements=value, digital_signature_method=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="checkout_borrow_license",
        op_kwargs={
            "LicenseArn": license_arn,
            "Entitlements": entitlements,
            "DigitalSignatureMethod": digital_signature_method,
            "NodeId": node_id,
            "CheckoutMetadata": checkout_metadata,
            "ClientToken": client_token,
        },
    )
