"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    license_configuration_arn: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the resource associations for the specified license configuration. Resource associations need not consume licenses from a license configuration. For example, an AMI or a stopped instance might not consume a license (depending on the license rules).

    Args:
        license_configuration_arn(str): Amazon Resource Name (ARN) of a license configuration.
        max_results(int, optional): Maximum number of results to return in a single call. Defaults to None.
        next_token(str, optional): Token for the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.association_for_license_configuration.list(
                ctx, license_configuration_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.association_for_license_configuration.list license_configuration_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="list_associations_for_license_configuration",
        op_kwargs={
            "LicenseConfigurationArn": license_configuration_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
