"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, token: str, token_properties: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.

    Args:
        token(str): Refresh token, encoded as a JWT token.
        token_properties(List, optional): Token properties to validate against those present in the JWT token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.license_manager.access_token.get(ctx, token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.license_manager.access_token.get token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="license-manager",
        operation="get_access_token",
        op_kwargs={"Token": token, "TokenProperties": token_properties},
    )
