"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def recognize(
    hub,
    ctx,
    bot_id: str,
    bot_alias_id: str,
    locale_id: str,
    session_id: str,
    request_content_type: str,
    session_state: str = None,
    request_attributes: str = None,
    response_content_type: str = None,
    input_stream: bytes = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sends user input to Amazon Lex V2. You can send text or speech. Clients use this API to send text and audio requests to Amazon Lex V2 at runtime. Amazon Lex V2 interprets the user input using the machine learning model built for the bot. The following request fields must be compressed with gzip and then base64 encoded before you send them to Amazon Lex V2.    requestAttributes   sessionState   The following response fields are compressed using gzip and then base64 encoded by Amazon Lex V2. Before you can use these fields, you must decode and decompress them.    inputTranscript   interpretations   messages   requestAttributes   sessionState   The example contains a Java application that compresses and encodes a Java object to send to Amazon Lex V2, and a second that decodes and decompresses a response from Amazon Lex V2.

    Args:
        bot_id(str): The identifier of the bot that should receive the request.
        bot_alias_id(str): The alias identifier in use for the bot that should receive the request.
        locale_id(str): The locale where the session is in use.
        session_id(str): The identifier of the session in use.
        session_state(str, optional): Sets the state of the session with the user. You can use this to set the current intent, attributes, context, and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the conversation with the user. The sessionState field must be compressed using gzip and then base64 encoded before sending to Amazon Lex V2. Defaults to None.
        request_attributes(str, optional): Request-specific information passed between the client application and Amazon Lex V2  The namespace x-amz-lex: is reserved for special attributes. Don't create any request attributes for prefix x-amz-lex:. The requestAttributes field must be compressed using gzip and then base64 encoded before sending to Amazon Lex V2. Defaults to None.
        request_content_type(str): Indicates the format for audio input or that the content is text. The header must start with one of the following prefixes:   PCM format, audio data must be in little-endian byte order.   audio/l16; rate=16000; channels=1   audio/x-l16; sample-rate=16000; channel-count=1   audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false     Opus format   audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4     Text format   text/plain; charset=utf-8    .
        response_content_type(str, optional): The message that Amazon Lex V2 returns in the response can be either text or speech based on the responseContentType value.   If the value is text/plain;charset=utf-8, Amazon Lex V2 returns text in the response.   If the value begins with audio/, Amazon Lex V2 returns speech in the response. Amazon Lex V2 uses Amazon Polly to generate the speech using the configuration that you specified in the requestContentType parameter. For example, if you specify audio/mpeg as the value, Amazon Lex V2 returns speech in the MPEG format.   If the value is audio/pcm, the speech returned is audio/pcm at 16 KHz in 16-bit, little-endian format.   The following are the accepted values:   audio/mpeg   audio/ogg   audio/pcm (16 KHz)   audio/* (defaults to mpeg)   text/plain; charset=utf-8    . Defaults to None.
        input_stream(bytes, optional): User input in PCM or Opus audio format or text format as described in the requestContentType parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_runtime.utterance.recognize(
                ctx,
                bot_id=value,
                bot_alias_id=value,
                locale_id=value,
                session_id=value,
                request_content_type=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_runtime.utterance.recognize bot_id=value, bot_alias_id=value, locale_id=value, session_id=value, request_content_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-runtime",
        operation="recognize_utterance",
        op_kwargs={
            "botId": bot_id,
            "botAliasId": bot_alias_id,
            "localeId": locale_id,
            "sessionId": session_id,
            "sessionState": session_state,
            "requestAttributes": request_attributes,
            "requestContentType": request_content_type,
            "responseContentType": response_content_type,
            "inputStream": input_stream,
        },
    )
