"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, bot_id: str, bot_alias_id: str, locale_id: str, session_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Removes session information for a specified bot, alias, and user ID.  You can use this operation to restart a conversation with a bot. When you remove a session, the entire history of the session is removed so that you can start again. You don't need to delete a session. Sessions have a time limit and will expire. Set the session time limit when you create the bot. The default is 5 minutes, but you can specify anything between 1 minute and 24 hours. If you specify a bot or alias ID that doesn't exist, you receive a BadRequestException.  If the locale doesn't exist in the bot, or if the locale hasn't been enables for the alias, you receive a BadRequestException.

    Args:
        bot_id(str): The identifier of the bot that contains the session data.
        bot_alias_id(str): The alias identifier in use for the bot that contains the session data.
        locale_id(str): The locale where the session is in use.
        session_id(str): The identifier of the session to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_runtime.session.delete(
                ctx, bot_id=value, bot_alias_id=value, locale_id=value, session_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_runtime.session.delete bot_id=value, bot_alias_id=value, locale_id=value, session_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-runtime",
        operation="delete_session",
        op_kwargs={
            "botId": bot_id,
            "botAliasId": bot_alias_id,
            "localeId": locale_id,
            "sessionId": session_id,
        },
    )


async def get(
    hub, ctx, bot_id: str, bot_alias_id: str, locale_id: str, session_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Returns session information for a specified bot, alias, and user. For example, you can use this operation to retrieve session information for a user that has left a long-running session in use. If the bot, alias, or session identifier doesn't exist, Amazon Lex V2 returns a BadRequestException. If the locale doesn't exist or is not enabled for the alias, you receive a BadRequestException.

    Args:
        bot_id(str): The identifier of the bot that contains the session data.
        bot_alias_id(str): The alias identifier in use for the bot that contains the session data.
        locale_id(str): The locale where the session is in use.
        session_id(str): The identifier of the session to return.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_runtime.session.get(
                ctx, bot_id=value, bot_alias_id=value, locale_id=value, session_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_runtime.session.get bot_id=value, bot_alias_id=value, locale_id=value, session_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-runtime",
        operation="get_session",
        op_kwargs={
            "botId": bot_id,
            "botAliasId": bot_alias_id,
            "localeId": locale_id,
            "sessionId": session_id,
        },
    )


async def put(
    hub,
    ctx,
    bot_id: str,
    bot_alias_id: str,
    locale_id: str,
    session_id: str,
    session_state: Dict,
    messages: List = None,
    request_attributes: Dict = None,
    response_content_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new session or modifies an existing session with an Amazon Lex V2 bot. Use this operation to enable your application to set the state of the bot.

    Args:
        bot_id(str): The identifier of the bot that receives the session data.
        bot_alias_id(str): The alias identifier of the bot that receives the session data.
        locale_id(str): The locale where the session is in use.
        session_id(str): The identifier of the session that receives the session data.
        messages(List, optional): A list of messages to send to the user. Messages are sent in the order that they are defined in the list. Defaults to None.
        session_state(Dict): Sets the state of the session with the user. You can use this to set the current intent, attributes, context, and dialog action. Use the dialog action to determine the next step that Amazon Lex V2 should use in the conversation with the user.
        request_attributes(Dict, optional): Request-specific information passed between Amazon Lex V2 and the client application. The namespace x-amz-lex: is reserved for special attributes. Don't create any request attributes with the prefix x-amz-lex:. Defaults to None.
        response_content_type(str, optional): The message that Amazon Lex V2 returns in the response can be either text or speech depending on the value of this parameter.    If the value is text/plain; charset=utf-8, Amazon Lex V2 returns text in the response.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_runtime.session.put(
                ctx,
                bot_id=value,
                bot_alias_id=value,
                locale_id=value,
                session_id=value,
                session_state=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_runtime.session.put bot_id=value, bot_alias_id=value, locale_id=value, session_id=value, session_state=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-runtime",
        operation="put_session",
        op_kwargs={
            "botId": bot_id,
            "botAliasId": bot_alias_id,
            "localeId": locale_id,
            "sessionId": session_id,
            "messages": messages,
            "sessionState": session_state,
            "requestAttributes": request_attributes,
            "responseContentType": response_content_type,
        },
    )
