"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "type"


async def create(
    hub,
    ctx,
    slot_type_name: str,
    value_selection_setting: Dict,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    description: str = None,
    slot_type_values: List = None,
    parent_slot_type_signature: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a custom slot type  To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a slot of this type can assume.

    Args:
        slot_type_name(str): The name for the slot. A slot type name must be unique within the account.
        description(str, optional): A description of the slot type. Use the description to help identify the slot type in lists. Defaults to None.
        slot_type_values(List, optional): A list of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. Defaults to None.
        value_selection_setting(Dict): Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:    OriginalValue - Returns the value entered by the user, if the user value is similar to the slot value.    TopResolution - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.   If you don't specify the valueSelectionSetting parameter, the default is OriginalValue.
        parent_slot_type_signature(str, optional): The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported. Defaults to None.
        bot_id(str): The identifier of the bot associated with this slot type.
        bot_version(str): The identifier of the bot version associated with this slot type.
        locale_id(str): The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see Supported languages.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.slot.type_.create(
                ctx,
                slot_type_name=value,
                value_selection_setting=value,
                bot_id=value,
                bot_version=value,
                locale_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.slot.type.create slot_type_name=value, value_selection_setting=value, bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="create_slot_type",
        op_kwargs={
            "slotTypeName": slot_type_name,
            "description": description,
            "slotTypeValues": slot_type_values,
            "valueSelectionSetting": value_selection_setting,
            "parentSlotTypeSignature": parent_slot_type_signature,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
        },
    )


async def delete(
    hub,
    ctx,
    slot_type_id: str,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    skip_resource_in_use_check: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Deletes a slot type from a bot locale. If a slot is using the slot type, Amazon Lex throws a ResourceInUseException exception. To avoid the exception, set the skipResourceInUseCheck parameter to true.

    Args:
        slot_type_id(str): The identifier of the slot type to delete.
        bot_id(str): The identifier of the bot associated with the slot type.
        bot_version(str): The version of the bot associated with the slot type.
        locale_id(str): The identifier of the language and locale that the slot type will be deleted from. The string must match one of the supported locales. For more information, see Supported languages.
        skip_resource_in_use_check(bool, optional): By default, the DeleteSlotType operations throws a ResourceInUseException exception if you try to delete a slot type used by a slot. Set the skipResourceInUseCheck parameter to true to skip this check and remove the slot type even if a slot uses it. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.slot.type_.delete(
                ctx, slot_type_id=value, bot_id=value, bot_version=value, locale_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.slot.type.delete slot_type_id=value, bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_slot_type",
        op_kwargs={
            "slotTypeId": slot_type_id,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
            "skipResourceInUseCheck": skip_resource_in_use_check,
        },
    )


async def describe(
    hub, ctx, slot_type_id: str, bot_id: str, bot_version: str, locale_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Gets metadata information about a slot type.

    Args:
        slot_type_id(str): The identifier of the slot type.
        bot_id(str): The identifier of the bot associated with the slot type.
        bot_version(str): The version of the bot associated with the slot type.
        locale_id(str): The identifier of the language and locale of the slot type to describe. The string must match one of the supported locales. For more information, see Supported languages.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.slot.type_.describe(
                ctx, slot_type_id=value, bot_id=value, bot_version=value, locale_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.slot.type.describe slot_type_id=value, bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="describe_slot_type",
        op_kwargs={
            "slotTypeId": slot_type_id,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
        },
    )


async def list_all(
    hub,
    ctx,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    sort_by: Dict = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of slot types that match the specified criteria.

    Args:
        bot_id(str): The unique identifier of the bot that contains the slot types.
        bot_version(str): The version of the bot that contains the slot type.
        locale_id(str): The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see Supported languages.
        sort_by(Dict, optional): Determines the sort order for the response from the ListSlotTypes operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order. Defaults to None.
        filters(List, optional): Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on. Defaults to None.
        max_results(int, optional): The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned. Defaults to None.
        next_token(str, optional): If the response from the ListSlotTypes operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.slot.type_.list_all(
                ctx, bot_id=value, bot_version=value, locale_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.slot.type.list_all bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="list_slot_types",
        op_kwargs={
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
            "sortBy": sort_by,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    slot_type_id: str,
    slot_type_name: str,
    value_selection_setting: Dict,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    description: str = None,
    slot_type_values: List = None,
    parent_slot_type_signature: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration of an existing slot type.

    Args:
        slot_type_id(str): The unique identifier of the slot type to update.
        slot_type_name(str): The new name of the slot type.
        description(str, optional): The new description of the slot type. Defaults to None.
        slot_type_values(List, optional): A new list of values and their optional synonyms that define the values that the slot type can take. Defaults to None.
        value_selection_setting(Dict): The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.
        parent_slot_type_signature(str, optional): The new built-in slot type that should be used as the parent of this slot type. Defaults to None.
        bot_id(str): The identifier of the bot that contains the slot type.
        bot_version(str): The version of the bot that contains the slot type. Must be DRAFT.
        locale_id(str): The identifier of the language and locale that contains the slot type. The string must match one of the supported locales. For more information, see Supported languages.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.slot.type_.update(
                ctx,
                slot_type_id=value,
                slot_type_name=value,
                value_selection_setting=value,
                bot_id=value,
                bot_version=value,
                locale_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.slot.type.update slot_type_id=value, slot_type_name=value, value_selection_setting=value, bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="update_slot_type",
        op_kwargs={
            "slotTypeId": slot_type_id,
            "slotTypeName": slot_type_name,
            "description": description,
            "slotTypeValues": slot_type_values,
            "valueSelectionSetting": value_selection_setting,
            "parentSlotTypeSignature": parent_slot_type_signature,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
        },
    )
