"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    slot_name: str,
    slot_type_id: str,
    value_elicitation_setting: Dict,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    intent_id: str,
    description: str = None,
    obfuscation_setting: Dict = None,
    multiple_values_setting: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an OrderPizza intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user.

    Args:
        slot_name(str): The name of the slot. Slot names must be unique within the bot that contains the slot.
        description(str, optional): A description of the slot. Use this to help identify the slot in lists. Defaults to None.
        slot_type_id(str): The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.
        value_elicitation_setting(Dict): Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot. .
        obfuscation_setting(Dict, optional): Determines how slot values are used in Amazon CloudWatch logs. If the value of the obfuscationSetting parameter is DefaultObfuscation, slot values are obfuscated in the log output. If the value is None, the actual value is present in the log output. The default is to obfuscate values in the CloudWatch logs. Defaults to None.
        bot_id(str): The identifier of the bot associated with the slot.
        bot_version(str): The version of the bot associated with the slot.
        locale_id(str): The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see Supported languages.
        intent_id(str): The identifier of the intent that contains the slot.
        multiple_values_setting(Dict, optional): Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to true in any other locale, Amazon Lex throws a ValidationException.  If the multipleValuesSetting is not set, the default value is false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.slot.init.create(
                ctx,
                slot_name=value,
                slot_type_id=value,
                value_elicitation_setting=value,
                bot_id=value,
                bot_version=value,
                locale_id=value,
                intent_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.slot.init.create slot_name=value, slot_type_id=value, value_elicitation_setting=value, bot_id=value, bot_version=value, locale_id=value, intent_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="create_slot",
        op_kwargs={
            "slotName": slot_name,
            "description": description,
            "slotTypeId": slot_type_id,
            "valueElicitationSetting": value_elicitation_setting,
            "obfuscationSetting": obfuscation_setting,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
            "intentId": intent_id,
            "multipleValuesSetting": multiple_values_setting,
        },
    )


async def delete(
    hub,
    ctx,
    slot_id: str,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    intent_id: str,
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified slot from an intent.

    Args:
        slot_id(str): The identifier of the slot to delete. .
        bot_id(str): The identifier of the bot associated with the slot to delete.
        bot_version(str): The version of the bot associated with the slot to delete.
        locale_id(str): The identifier of the language and locale that the slot will be deleted from. The string must match one of the supported locales. For more information, see Supported languages.
        intent_id(str): The identifier of the intent associated with the slot.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.slot.init.delete(
                ctx,
                slot_id=value,
                bot_id=value,
                bot_version=value,
                locale_id=value,
                intent_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.slot.init.delete slot_id=value, bot_id=value, bot_version=value, locale_id=value, intent_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_slot",
        op_kwargs={
            "slotId": slot_id,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
            "intentId": intent_id,
        },
    )


async def describe(
    hub,
    ctx,
    slot_id: str,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    intent_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets metadata information about a slot.

    Args:
        slot_id(str): The unique identifier for the slot.
        bot_id(str): The identifier of the bot associated with the slot.
        bot_version(str): The version of the bot associated with the slot.
        locale_id(str): The identifier of the language and locale of the slot to describe. The string must match one of the supported locales. For more information, see Supported languages.
        intent_id(str): The identifier of the intent that contains the slot.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.slot.init.describe(
                ctx,
                slot_id=value,
                bot_id=value,
                bot_version=value,
                locale_id=value,
                intent_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.slot.init.describe slot_id=value, bot_id=value, bot_version=value, locale_id=value, intent_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="describe_slot",
        op_kwargs={
            "slotId": slot_id,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
            "intentId": intent_id,
        },
    )


async def list_all(
    hub,
    ctx,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    intent_id: str,
    sort_by: Dict = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of slots that match the specified criteria.

    Args:
        bot_id(str): The identifier of the bot that contains the slot.
        bot_version(str): The version of the bot that contains the slot.
        locale_id(str): The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see Supported languages.
        intent_id(str): The unique identifier of the intent that contains the slot.
        sort_by(Dict, optional): Determines the sort order for the response from the ListSlots operation. You can choose to sort by the slot name or last updated date in either ascending or descending order. Defaults to None.
        filters(List, optional): Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on. Defaults to None.
        max_results(int, optional): The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned. Defaults to None.
        next_token(str, optional): If the response from the ListSlots operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.slot.init.list_all(
                ctx, bot_id=value, bot_version=value, locale_id=value, intent_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.slot.init.list_all bot_id=value, bot_version=value, locale_id=value, intent_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="list_slots",
        op_kwargs={
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
            "intentId": intent_id,
            "sortBy": sort_by,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    slot_id: str,
    slot_name: str,
    slot_type_id: str,
    value_elicitation_setting: Dict,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    intent_id: str,
    description: str = None,
    obfuscation_setting: Dict = None,
    multiple_values_setting: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the settings for a slot.

    Args:
        slot_id(str): The unique identifier for the slot to update.
        slot_name(str): The new name for the slot.
        description(str, optional): The new description for the slot. Defaults to None.
        slot_type_id(str): The unique identifier of the new slot type to associate with this slot. .
        value_elicitation_setting(Dict): A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.
        obfuscation_setting(Dict, optional): New settings that determine how slot values are formatted in Amazon CloudWatch logs. . Defaults to None.
        bot_id(str): The unique identifier of the bot that contains the slot.
        bot_version(str): The version of the bot that contains the slot. Must always be DRAFT.
        locale_id(str): The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see Supported languages.
        intent_id(str): The identifier of the intent that contains the slot.
        multiple_values_setting(Dict, optional): Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to true in any other locale, Amazon Lex throws a ValidationException. If the multipleValuesSetting is not set, the default value is false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.slot.init.update(
                ctx,
                slot_id=value,
                slot_name=value,
                slot_type_id=value,
                value_elicitation_setting=value,
                bot_id=value,
                bot_version=value,
                locale_id=value,
                intent_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.slot.init.update slot_id=value, slot_name=value, slot_type_id=value, value_elicitation_setting=value, bot_id=value, bot_version=value, locale_id=value, intent_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="update_slot",
        op_kwargs={
            "slotId": slot_id,
            "slotName": slot_name,
            "description": description,
            "slotTypeId": slot_type_id,
            "valueElicitationSetting": value_elicitation_setting,
            "obfuscationSetting": obfuscation_setting,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
            "intentId": intent_id,
            "multipleValuesSetting": multiple_values_setting,
        },
    )
