"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    resource_arn: str,
    statement_id: str,
    effect: str,
    principal: List,
    action: List,
    condition: Dict = None,
    expected_revision_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created. You can't create a resource policy statement that allows cross-account access.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
        statement_id(str): The name of the statement. The ID is the same as the Sid IAM property. The statement name must be unique within the policy. For more information, see IAM JSON policy elements: Sid. .
        effect(str): Determines whether the statement allows or denies access to the resource.
        principal(List): An IAM principal, such as an IAM users, IAM roles, or AWS services that is allowed or denied access to a resource. For more information, see AWS JSON policy elements: Principal.
        action(List): The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see  Actions, resources, and condition keys for Amazon Lex V2.
        condition(Dict, optional): Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key. For more information, see IAM JSON policy elements: Condition . Defaults to None.
        expected_revision_id(str, optional): The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception. If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.resource.policy.statement.create(
                ctx,
                resource_arn=value,
                statement_id=value,
                effect=value,
                principal=value,
                action=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.resource.policy.statement.create resource_arn=value, statement_id=value, effect=value, principal=value, action=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="create_resource_policy_statement",
        op_kwargs={
            "resourceArn": resource_arn,
            "statementId": statement_id,
            "effect": effect,
            "principal": principal,
            "action": action,
            "condition": condition,
            "expectedRevisionId": expected_revision_id,
        },
    )


async def delete(
    hub, ctx, resource_arn: str, statement_id: str, expected_revision_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have a policy attached, Amazon Lex returns an exception.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
        statement_id(str): The name of the statement (SID) to delete from the policy.
        expected_revision_id(str, optional): The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception. If you don't specify a revision, Amazon Lex removes the current contents of the statement. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.resource.policy.statement.delete(
                ctx, resource_arn=value, statement_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.resource.policy.statement.delete resource_arn=value, statement_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_resource_policy_statement",
        op_kwargs={
            "resourceArn": resource_arn,
            "statementId": statement_id,
            "expectedRevisionId": expected_revision_id,
        },
    )
