"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, resource_arn: str, policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new resource policy with the specified policy statements.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
        policy(str): A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see  IAM JSON policy reference .  If the policy isn't valid, Amazon Lex returns a validation exception.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.resource.policy.init.create(
                ctx, resource_arn=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.resource.policy.init.create resource_arn=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="create_resource_policy",
        op_kwargs={"resourceArn": resource_arn, "policy": policy},
    )


async def delete(hub, ctx, resource_arn: str, expected_revision_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex returns an exception.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.
        expected_revision_id(str, optional): The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex returns an exception If you don't specify a revision ID, Amazon Lex will delete the current policy. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.resource.policy.init.delete(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.resource.policy.init.delete resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_resource_policy",
        op_kwargs={
            "resourceArn": resource_arn,
            "expectedRevisionId": expected_revision_id,
        },
    )


async def describe(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the resource policy and policy revision for a bot or bot alias.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.resource.policy.init.describe(
                ctx, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.resource.policy.init.describe resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="describe_resource_policy",
        op_kwargs={"resourceArn": resource_arn},
    )


async def update(
    hub, ctx, resource_arn: str, policy: str, expected_revision_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
        policy(str): A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see  IAM JSON policy reference .  If the policy isn't valid, Amazon Lex returns a validation exception.
        expected_revision_id(str, optional): The identifier of the revision of the policy to update. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception. If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.resource.policy.init.update(
                ctx, resource_arn=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.resource.policy.init.update resource_arn=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="update_resource_policy",
        op_kwargs={
            "resourceArn": resource_arn,
            "policy": policy,
            "expectedRevisionId": expected_revision_id,
        },
    )
