"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.
        tags(Dict): A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.resource.init.tag(
                ctx, resource_arn=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.resource.init.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="tag_resource",
        op_kwargs={"resourceARN": resource_arn, "tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes tags from a bot, bot alias, or bot channel.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource to remove the tags from.
        tag_keys(List): A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.resource.init.untag(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.resource.init.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="untag_resource",
        op_kwargs={"resourceARN": resource_arn, "tagKeys": tag_keys},
    )
