"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    intent_name: str,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    description: str = None,
    parent_intent_signature: str = None,
    sample_utterances: List = None,
    dialog_code_hook: Dict = None,
    fulfillment_code_hook: Dict = None,
    intent_confirmation_setting: Dict = None,
    intent_closing_setting: Dict = None,
    input_contexts: List = None,
    output_contexts: List = None,
    kendra_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an intent. To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza ordering bot you would create an OrderPizza intent. When you create an intent, you must provide a name. You can optionally provide the following:   Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances for built-in intents.   Information to be gathered. You specify slots for the information that you bot requests from the user. You can specify standard slot types, such as date and time, or custom slot types for your application.   How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of the intent information is available.   A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"   A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."   A follow-up prompt that asks the user for additional activity. For example, "Do you want a drink with your pizza?"

    Args:
        intent_name(str): The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
        description(str, optional): A description of the intent. Use the description to help identify the intent in lists. Defaults to None.
        parent_intent_signature(str, optional): A unique identifier for the built-in intent to base this intent on. Defaults to None.
        sample_utterances(List, optional): An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza".  In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user.. . Defaults to None.
        dialog_code_hook(Dict, optional): Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, glutenIntolerant to true. You might find John's phone number and set the corresponding session attribute. Defaults to None.
        fulfillment_code_hook(Dict, optional): Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer's location and then place an order on the customer's behalf. Defaults to None.
        intent_confirmation_setting(Dict, optional): Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent. Defaults to None.
        intent_closing_setting(Dict, optional): Sets the response that Amazon Lex sends to the user when the intent is closed. Defaults to None.
        input_contexts(List, optional): A list of contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime.  For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond. An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent. Defaults to None.
        output_contexts(List, optional): A lists of contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer.  When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. Defaults to None.
        kendra_configuration(Dict, optional): Configuration information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. Defaults to None.
        bot_id(str): The identifier of the bot associated with this intent.
        bot_version(str): The identifier of the version of the bot associated with this intent.
        locale_id(str): The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see Supported languages.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.intent.create(
                ctx, intent_name=value, bot_id=value, bot_version=value, locale_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.intent.create intent_name=value, bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="create_intent",
        op_kwargs={
            "intentName": intent_name,
            "description": description,
            "parentIntentSignature": parent_intent_signature,
            "sampleUtterances": sample_utterances,
            "dialogCodeHook": dialog_code_hook,
            "fulfillmentCodeHook": fulfillment_code_hook,
            "intentConfirmationSetting": intent_confirmation_setting,
            "intentClosingSetting": intent_closing_setting,
            "inputContexts": input_contexts,
            "outputContexts": output_contexts,
            "kendraConfiguration": kendra_configuration,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
        },
    )


async def delete(
    hub, ctx, intent_id: str, bot_id: str, bot_version: str, locale_id: str
) -> None:
    r"""
    **Autogenerated function**

    Removes the specified intent. Deleting an intent also deletes the slots associated with the intent.

    Args:
        intent_id(str): The unique identifier of the intent to delete.
        bot_id(str): The identifier of the bot associated with the intent.
        bot_version(str): The version of the bot associated with the intent.
        locale_id(str): The identifier of the language and locale where the bot will be deleted. The string must match one of the supported locales. For more information, see Supported languages.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.intent.delete(
                ctx, intent_id=value, bot_id=value, bot_version=value, locale_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.intent.delete intent_id=value, bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_intent",
        op_kwargs={
            "intentId": intent_id,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
        },
    )


async def describe(
    hub, ctx, intent_id: str, bot_id: str, bot_version: str, locale_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata about an intent.

    Args:
        intent_id(str): The identifier of the intent to describe.
        bot_id(str): The identifier of the bot associated with the intent.
        bot_version(str): The version of the bot associated with the intent.
        locale_id(str): The identifier of the language and locale of the intent to describe. The string must match one of the supported locales. For more information, see Supported languages.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.intent.describe(
                ctx, intent_id=value, bot_id=value, bot_version=value, locale_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.intent.describe intent_id=value, bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="describe_intent",
        op_kwargs={
            "intentId": intent_id,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
        },
    )


async def list_all(
    hub,
    ctx,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    sort_by: Dict = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Get a list of intents that meet the specified criteria.

    Args:
        bot_id(str): The unique identifier of the bot that contains the intent.
        bot_version(str): The version of the bot that contains the intent.
        locale_id(str): The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see Supported languages.
        sort_by(Dict, optional): Determines the sort order for the response from the ListIntents operation. You can choose to sort by the intent name or last updated date in either ascending or descending order. Defaults to None.
        filters(List, optional): Provides the specification of a filter used to limit the intents in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on. Defaults to None.
        max_results(int, optional): The maximum number of intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned. Defaults to None.
        next_token(str, optional): If the response from the ListIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.intent.list_all(
                ctx, bot_id=value, bot_version=value, locale_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.intent.list_all bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="list_intents",
        op_kwargs={
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
            "sortBy": sort_by,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    intent_id: str,
    intent_name: str,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    description: str = None,
    parent_intent_signature: str = None,
    sample_utterances: List = None,
    dialog_code_hook: Dict = None,
    fulfillment_code_hook: Dict = None,
    slot_priorities: List = None,
    intent_confirmation_setting: Dict = None,
    intent_closing_setting: Dict = None,
    input_contexts: List = None,
    output_contexts: List = None,
    kendra_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the settings for an intent.

    Args:
        intent_id(str): The unique identifier of the intent to update.
        intent_name(str): The new name for the intent.
        description(str, optional): The new description of the intent. Defaults to None.
        parent_intent_signature(str, optional): The signature of the new built-in intent to use as the parent of this intent. Defaults to None.
        sample_utterances(List, optional): New utterances used to invoke the intent. Defaults to None.
        dialog_code_hook(Dict, optional): The new Lambda function to use between each turn of the conversation with the bot. Defaults to None.
        fulfillment_code_hook(Dict, optional): The new Lambda function to call when all of the intents required slots are provided and the intent is ready for fulfillment. Defaults to None.
        slot_priorities(List, optional): A new list of slots and their priorities that are contained by the intent. Defaults to None.
        intent_confirmation_setting(Dict, optional): New prompts that Amazon Lex sends to the user to confirm the completion of an intent. Defaults to None.
        intent_closing_setting(Dict, optional): The new response that Amazon Lex sends the user when the intent is closed. Defaults to None.
        input_contexts(List, optional): A new list of contexts that must be active in order for Amazon Lex to consider the intent. Defaults to None.
        output_contexts(List, optional): A new list of contexts that Amazon Lex activates when the intent is fulfilled. Defaults to None.
        kendra_configuration(Dict, optional): New configuration settings for connecting to an Amazon Kendra index. Defaults to None.
        bot_id(str): The identifier of the bot that contains the intent.
        bot_version(str): The version of the bot that contains the intent. Must be DRAFT.
        locale_id(str): The identifier of the language and locale where this intent is used. The string must match one of the supported locales. For more information, see Supported languages.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.intent.update(
                ctx,
                intent_id=value,
                intent_name=value,
                bot_id=value,
                bot_version=value,
                locale_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.intent.update intent_id=value, intent_name=value, bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="update_intent",
        op_kwargs={
            "intentId": intent_id,
            "intentName": intent_name,
            "description": description,
            "parentIntentSignature": parent_intent_signature,
            "sampleUtterances": sample_utterances,
            "dialogCodeHook": dialog_code_hook,
            "fulfillmentCodeHook": fulfillment_code_hook,
            "slotPriorities": slot_priorities,
            "intentConfirmationSetting": intent_confirmation_setting,
            "intentClosingSetting": intent_closing_setting,
            "inputContexts": input_contexts,
            "outputContexts": output_contexts,
            "kendraConfiguration": kendra_configuration,
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
        },
    )
