"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "import"


async def delete(hub, ctx, import_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a previous import and the associated file stored in an S3 bucket.

    Args:
        import_id(str): The unique identifier of the import to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.import_.delete(ctx, import_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.import.delete import_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_import",
        op_kwargs={"importId": import_id},
    )


async def describe(hub, ctx, import_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a specific import.

    Args:
        import_id(str): The unique identifier of the import to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.import_.describe(ctx, import_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.import.describe import_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="describe_import",
        op_kwargs={"importId": import_id},
    )


async def list_all(
    hub,
    ctx,
    bot_id: str = None,
    bot_version: str = None,
    sort_by: Dict = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the imports for a bot or bot locale. Imports are kept in the list for 7 days.

    Args:
        bot_id(str, optional): The unique identifier that Amazon Lex assigned to the bot. Defaults to None.
        bot_version(str, optional): The version of the bot to list imports for. Defaults to None.
        sort_by(Dict, optional): Determines the field that the list of imports is sorted by. You can sort by the LastUpdatedDateTime field in ascending or descending order. Defaults to None.
        filters(List, optional): Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on. Defaults to None.
        max_results(int, optional): The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned. Defaults to None.
        next_token(str, optional): If the response from the ListImports operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.import_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.import.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="list_imports",
        op_kwargs={
            "botId": bot_id,
            "botVersion": bot_version,
            "sortBy": sort_by,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def start(
    hub,
    ctx,
    import_id: str,
    resource_specification: Dict,
    merge_strategy: str,
    file_password: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts importing a bot or bot locale from a zip archive that you uploaded to an S3 bucket.

    Args:
        import_id(str): The unique identifier for the import. It is included in the response from the operation.
        resource_specification(Dict): Parameters for creating the bot or bot locale.
        merge_strategy(str): The strategy to use when there is a name conflict between the imported resource and an existing resource. When the merge strategy is FailOnConflict existing resources are not overwritten and the import fails.
        file_password(str, optional): The password used to encrypt the zip archive that contains the bot or bot locale definition. You should always encrypt the zip archive to protect it during transit between your site and Amazon Lex. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.import_.start(
                ctx, import_id=value, resource_specification=value, merge_strategy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.import.start import_id=value, resource_specification=value, merge_strategy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="start_import",
        op_kwargs={
            "importId": import_id,
            "resourceSpecification": resource_specification,
            "mergeStrategy": merge_strategy,
            "filePassword": file_password,
        },
    )
