"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, resource_specification: Dict, file_format: str, file_password: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot. You can create an archive that contains the complete definition of a bot, or you can specify that the archive contain only the definition of a single bot locale. For more information about exporting bots, and about the structure of the export archive, see  Importing and exporting bots

    Args:
        resource_specification(Dict): Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource to export.
        file_format(str): The file format of the bot or bot locale definition files.
        file_password(str, optional): An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the archive to protect the data in transit between Amazon Lex and your local computer. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.export.create(
                ctx, resource_specification=value, file_format=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.export.create resource_specification=value, file_format=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="create_export",
        op_kwargs={
            "resourceSpecification": resource_specification,
            "fileFormat": file_format,
            "filePassword": file_password,
        },
    )


async def delete(hub, ctx, export_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a previous export and the associated files stored in an S3 bucket.

    Args:
        export_id(str): The unique identifier of the export to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.export.delete(ctx, export_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.export.delete export_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_export",
        op_kwargs={"exportId": export_id},
    )


async def describe(hub, ctx, export_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a specific export.

    Args:
        export_id(str): The unique identifier of the export to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.export.describe(ctx, export_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.export.describe export_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="describe_export",
        op_kwargs={"exportId": export_id},
    )


async def list_all(
    hub,
    ctx,
    bot_id: str = None,
    bot_version: str = None,
    sort_by: Dict = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the exports for a bot or bot locale. Exports are kept in the list for 7 days.

    Args:
        bot_id(str, optional): The unique identifier that Amazon Lex assigned to the bot. Defaults to None.
        bot_version(str, optional): The version of the bot to list exports for. . Defaults to None.
        sort_by(Dict, optional): Determines the field that the list of exports is sorted by. You can sort by the LastUpdatedDateTime field in ascending or descending order. Defaults to None.
        filters(List, optional): Provides the specification of a filter used to limit the exports in the response to only those that match the filter specification. You can only specify one filter and one string to filter on. Defaults to None.
        max_results(int, optional): The maximum number of exports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned. Defaults to None.
        next_token(str, optional): If the response from the ListExports operation contans more results that specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.export.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.export.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="list_exports",
        op_kwargs={
            "botId": bot_id,
            "botVersion": bot_version,
            "sortBy": sort_by,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(hub, ctx, export_id: str, file_password: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the password used to protect an export zip archive. The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the operation.

    Args:
        export_id(str): The unique identifier Amazon Lex assigned to the export.
        file_password(str, optional): The new password to use to encrypt the export zip archive. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.export.update(ctx, export_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.export.update export_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="update_export",
        op_kwargs={"exportId": export_id, "filePassword": file_password},
    )
