"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    locale_id: str,
    sort_by: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.  To use a built-in intent as a the base for your own intent, include the built-in intent signature in the parentIntentSignature parameter when you call the CreateIntent operation. For more information, see CreateIntent.

    Args:
        locale_id(str): The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see Supported languages.
        sort_by(Dict, optional): Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order. Defaults to None.
        max_results(int, optional): The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned. Defaults to None.
        next_token(str, optional): If the response from the ListBuiltInIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.built_in_.intent.list_all(ctx, locale_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.built_in_.intent.list_all locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="list_built_in_intents",
        op_kwargs={
            "localeId": locale_id,
            "sortBy": sort_by,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
