"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    sort_by: Dict = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of available bots.

    Args:
        sort_by(Dict, optional): Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in ascending or descending order. Defaults to None.
        filters(List, optional): Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on. Defaults to None.
        max_results(int, optional): The maximum number of bots to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned. Defaults to None.
        next_token(str, optional): If the response from the ListBots operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bots.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bots.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="list_bots",
        op_kwargs={
            "sortBy": sort_by,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
