"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    bot_id: str,
    bot_version_locale_specification: Dict,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version of the bot based on the DRAFT version. If the DRAFT version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it returns the last created version. When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.

    Args:
        bot_id(str): The identifier of the bot to create the version for.
        description(str, optional): A description of the version. Use the description to help identify the version in lists. Defaults to None.
        bot_version_locale_specification(Dict): Specifies the locales that Amazon Lex adds to this version. You can choose the Draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.version.create(
                ctx, bot_id=value, bot_version_locale_specification=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.version.create bot_id=value, bot_version_locale_specification=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="create_bot_version",
        op_kwargs={
            "botId": bot_id,
            "description": description,
            "botVersionLocaleSpecification": bot_version_locale_specification,
        },
    )


async def delete(
    hub, ctx, bot_id: str, bot_version: str, skip_resource_in_use_check: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specific version of a bot. To delete all version of a bot, use the DeleteBot operation.

    Args:
        bot_id(str): The identifier of the bot that contains the version.
        bot_version(str): The version of the bot to delete.
        skip_resource_in_use_check(bool, optional): By default, the DeleteBotVersion operations throws a ResourceInUseException exception if you try to delete a bot version that has an alias pointing at it. Set the skipResourceInUseCheck parameter to true to skip this check and remove the version even if an alias points to it. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.version.delete(
                ctx, bot_id=value, bot_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.version.delete bot_id=value, bot_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_bot_version",
        op_kwargs={
            "botId": bot_id,
            "botVersion": bot_version,
            "skipResourceInUseCheck": skip_resource_in_use_check,
        },
    )


async def describe(hub, ctx, bot_id: str, bot_version: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides metadata about a version of a bot.

    Args:
        bot_id(str): The identifier of the bot containing the version to return metadata for.
        bot_version(str): The version of the bot to return metadata for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.version.describe(
                ctx, bot_id=value, bot_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.version.describe bot_id=value, bot_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="describe_bot_version",
        op_kwargs={"botId": bot_id, "botVersion": bot_version},
    )


async def list_all(
    hub,
    ctx,
    bot_id: str,
    sort_by: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about all of the versions of a bot. The ListBotVersions operation returns a summary of each version of a bot. For example, if a bot has three numbered versions, the ListBotVersions operation returns for summaries, one for each numbered version and one for the DRAFT version. The ListBotVersions operation always returns at least one version, the DRAFT version.

    Args:
        bot_id(str): The identifier of the bot to list versions for.
        sort_by(Dict, optional): Specifies sorting parameters for the list of versions. You can specify that the list be sorted by version name in either ascending or descending order. Defaults to None.
        max_results(int, optional): The maximum number of versions to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned. Defaults to None.
        next_token(str, optional): If the response to the ListBotVersion operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.version.list_all(ctx, bot_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.version.list_all bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="list_bot_versions",
        op_kwargs={
            "botId": bot_id,
            "sortBy": sort_by,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
