"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def build(hub, ctx, bot_id: str, bot_version: str, locale_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.

    Args:
        bot_id(str): The identifier of the bot to build. The identifier is returned in the response from the operation.
        bot_version(str): The version of the bot to build. This can only be the draft version of the bot.
        locale_id(str): The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see Supported languages.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.locale.build(
                ctx, bot_id=value, bot_version=value, locale_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.locale.build bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="build_bot_locale",
        op_kwargs={"botId": bot_id, "botVersion": bot_version, "localeId": locale_id},
    )


async def create(
    hub,
    ctx,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    nlu_intent_confidence_threshold: float,
    description: str = None,
    voice_settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.

    Args:
        bot_id(str): The identifier of the bot to create the locale for.
        bot_version(str): The version of the bot to create the locale for. This can only be the draft version of the bot.
        locale_id(str): The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see Supported languages.
        description(str, optional): A description of the bot locale. Use this to help identify the bot locale in lists. Defaults to None.
        nlu_intent_confidence_threshold(float): Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For example, suppose a bot is configured with the confidence threshold of 0.80 and the AMAZON.FallbackIntent. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the PostText operation would be:   AMAZON.FallbackIntent   IntentA   IntentB   IntentC  .
        voice_settings(Dict, optional): The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.locale.create(
                ctx,
                bot_id=value,
                bot_version=value,
                locale_id=value,
                nlu_intent_confidence_threshold=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.locale.create bot_id=value, bot_version=value, locale_id=value, nlu_intent_confidence_threshold=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="create_bot_locale",
        op_kwargs={
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
            "description": description,
            "nluIntentConfidenceThreshold": nlu_intent_confidence_threshold,
            "voiceSettings": voice_settings,
        },
    )


async def delete(hub, ctx, bot_id: str, bot_version: str, locale_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a locale from a bot. When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.

    Args:
        bot_id(str): The unique identifier of the bot that contains the locale.
        bot_version(str): The version of the bot that contains the locale. .
        locale_id(str): The identifier of the language and locale that will be deleted. The string must match one of the supported locales. For more information, see Supported languages.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.locale.delete(
                ctx, bot_id=value, bot_version=value, locale_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.locale.delete bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_bot_locale",
        op_kwargs={"botId": bot_id, "botVersion": bot_version, "localeId": locale_id},
    )


async def describe(hub, ctx, bot_id: str, bot_version: str, locale_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the settings that a bot has for a specific locale.

    Args:
        bot_id(str): The identifier of the bot associated with the locale.
        bot_version(str): The identifier of the version of the bot associated with the locale.
        locale_id(str): The unique identifier of the locale to describe. The string must match one of the supported locales. For more information, see Supported languages. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.locale.describe(
                ctx, bot_id=value, bot_version=value, locale_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.locale.describe bot_id=value, bot_version=value, locale_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="describe_bot_locale",
        op_kwargs={"botId": bot_id, "botVersion": bot_version, "localeId": locale_id},
    )


async def list_all(
    hub,
    ctx,
    bot_id: str,
    bot_version: str,
    sort_by: Dict = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of locales for the specified bot.

    Args:
        bot_id(str): The identifier of the bot to list locales for.
        bot_version(str): The version of the bot to list locales for.
        sort_by(Dict, optional): Specifies sorting parameters for the list of locales. You can sort by locale name in ascending or descending order. Defaults to None.
        filters(List, optional): Provides the specification for a filter used to limit the response to only those locales that match the filter specification. You can only specify one filter and one value to filter on. Defaults to None.
        max_results(int, optional): The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned. Defaults to None.
        next_token(str, optional): If the response from the ListBotLocales operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token as the nextToken parameter to return the next page of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.locale.list_all(
                ctx, bot_id=value, bot_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.locale.list_all bot_id=value, bot_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="list_bot_locales",
        op_kwargs={
            "botId": bot_id,
            "botVersion": bot_version,
            "sortBy": sort_by,
            "filters": filters,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    bot_id: str,
    bot_version: str,
    locale_id: str,
    nlu_intent_confidence_threshold: float,
    description: str = None,
    voice_settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the settings that a bot has for a specific locale.

    Args:
        bot_id(str): The unique identifier of the bot that contains the locale.
        bot_version(str): The version of the bot that contains the locale to be updated. The version can only be the DRAFT version.
        locale_id(str): The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see Supported languages.
        description(str, optional): The new description of the locale. Defaults to None.
        nlu_intent_confidence_threshold(float): The new confidence threshold where Amazon Lex inserts the AMAZON.FallbackIntent and AMAZON.KendraSearchIntent intents in the list of possible intents for an utterance.
        voice_settings(Dict, optional): The new Amazon Polly voice Amazon Lex should use for voice interaction with the user. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.locale.update(
                ctx,
                bot_id=value,
                bot_version=value,
                locale_id=value,
                nlu_intent_confidence_threshold=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.locale.update bot_id=value, bot_version=value, locale_id=value, nlu_intent_confidence_threshold=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="update_bot_locale",
        op_kwargs={
            "botId": bot_id,
            "botVersion": bot_version,
            "localeId": locale_id,
            "description": description,
            "nluIntentConfidenceThreshold": nlu_intent_confidence_threshold,
            "voiceSettings": voice_settings,
        },
    )
