"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    bot_name: str,
    role_arn: str,
    data_privacy: Dict,
    idle_session_ttl_in_seconds: int,
    description: str = None,
    bot_tags: Dict = None,
    test_bot_alias_tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Lex conversational bot.

    Args:
        bot_name(str): The name of the bot. The bot name must be unique in the account that creates the bot.
        description(str, optional): A description of the bot. It appears in lists to help you identify a particular bot. Defaults to None.
        role_arn(str): The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.
        data_privacy(Dict): Provides information on additional privacy protections Amazon Lex should use with the bot's data.
        idle_session_ttl_in_seconds(int): The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.  A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout. You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
        bot_tags(Dict, optional): A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the UpdateBot operation to update tags. To update tags, use the TagResource operation. Defaults to None.
        test_bot_alias_tags(Dict, optional): A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the UpdateAlias operation to update tags. To update tags on the test alias, use the TagResource operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.init.create(
                ctx,
                bot_name=value,
                role_arn=value,
                data_privacy=value,
                idle_session_ttl_in_seconds=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.init.create bot_name=value, role_arn=value, data_privacy=value, idle_session_ttl_in_seconds=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="create_bot",
        op_kwargs={
            "botName": bot_name,
            "description": description,
            "roleArn": role_arn,
            "dataPrivacy": data_privacy,
            "idleSessionTTLInSeconds": idle_session_ttl_in_seconds,
            "botTags": bot_tags,
            "testBotAliasTags": test_bot_alias_tags,
        },
    )


async def delete(
    hub, ctx, bot_id: str, skip_resource_in_use_check: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes all versions of a bot, including the Draft version. To delete a specific version, use the DeleteBotVersion operation. When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all locales, intents, slot, and slot types defined for the bot. If a bot has an alias, the DeleteBot operation returns a ResourceInUseException exception. If you want to delete the bot and the alias, set the skipResourceInUseCheck parameter to true.

    Args:
        bot_id(str): The identifier of the bot to delete. .
        skip_resource_in_use_check(bool, optional): When true, Amazon Lex doesn't check to see if another resource, such as an alias, is using the bot before it is deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.init.delete(ctx, bot_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.init.delete bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_bot",
        op_kwargs={
            "botId": bot_id,
            "skipResourceInUseCheck": skip_resource_in_use_check,
        },
    )


async def describe(hub, ctx, bot_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides metadata information about a bot.

    Args:
        bot_id(str): The unique identifier of the bot to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.init.describe(ctx, bot_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.init.describe bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="describe_bot",
        op_kwargs={"botId": bot_id},
    )


async def update(
    hub,
    ctx,
    bot_id: str,
    bot_name: str,
    role_arn: str,
    data_privacy: Dict,
    idle_session_ttl_in_seconds: int,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration of an existing bot.

    Args:
        bot_id(str): The unique identifier of the bot to update. This identifier is returned by the CreateBot operation.
        bot_name(str): The new name of the bot. The name must be unique in the account that creates the bot.
        description(str, optional): A description of the bot. Defaults to None.
        role_arn(str): The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.
        data_privacy(Dict): Provides information on additional privacy protections Amazon Lex should use with the bot's data.
        idle_session_ttl_in_seconds(int): The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout. You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.init.update(
                ctx,
                bot_id=value,
                bot_name=value,
                role_arn=value,
                data_privacy=value,
                idle_session_ttl_in_seconds=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.init.update bot_id=value, bot_name=value, role_arn=value, data_privacy=value, idle_session_ttl_in_seconds=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="update_bot",
        op_kwargs={
            "botId": bot_id,
            "botName": bot_name,
            "description": description,
            "roleArn": role_arn,
            "dataPrivacy": data_privacy,
            "idleSessionTTLInSeconds": idle_session_ttl_in_seconds,
        },
    )
