"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, bot_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of aliases for the specified bot.

    Args:
        bot_id(str): The identifier of the bot to list aliases for.
        max_results(int, optional): The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned. Defaults to None.
        next_token(str, optional): If the response from the ListBotAliases operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.aliase.list_all(ctx, bot_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.aliase.list_all bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="list_bot_aliases",
        op_kwargs={"botId": bot_id, "maxResults": max_results, "nextToken": next_token},
    )
