"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    bot_alias_name: str,
    bot_id: str,
    description: str = None,
    bot_version: str = None,
    bot_alias_locale_settings: Dict = None,
    conversation_log_settings: Dict = None,
    sentiment_analysis_settings: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot. For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.

    Args:
        bot_alias_name(str): The alias to create. The name must be unique for the bot.
        description(str, optional): A description of the alias. Use this description to help identify the alias. Defaults to None.
        bot_version(str, optional): The version of the bot that this alias points to. You can use the operation to change the bot version associated with the alias. Defaults to None.
        bot_alias_locale_settings(Dict, optional): Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales. Defaults to None.
        conversation_log_settings(Dict, optional): Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3. Defaults to None.
        sentiment_analysis_settings(Dict, optional): Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances. Defaults to None.
        bot_id(str): The unique identifier of the bot that the alias applies to.
        tags(Dict, optional): A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the UpdateBotAlias operation to update the tags on a bot alias. To update tags, use the TagResource operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.alias.create(
                ctx, bot_alias_name=value, bot_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.alias.create bot_alias_name=value, bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="create_bot_alias",
        op_kwargs={
            "botAliasName": bot_alias_name,
            "description": description,
            "botVersion": bot_version,
            "botAliasLocaleSettings": bot_alias_locale_settings,
            "conversationLogSettings": conversation_log_settings,
            "sentimentAnalysisSettings": sentiment_analysis_settings,
            "botId": bot_id,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, bot_alias_id: str, bot_id: str, skip_resource_in_use_check: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified bot alias.

    Args:
        bot_alias_id(str): The unique identifier of the bot alias to delete.
        bot_id(str): The unique identifier of the bot associated with the alias to delete.
        skip_resource_in_use_check(bool, optional): When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias before it is deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.alias.delete(
                ctx, bot_alias_id=value, bot_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.alias.delete bot_alias_id=value, bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="delete_bot_alias",
        op_kwargs={
            "botAliasId": bot_alias_id,
            "botId": bot_id,
            "skipResourceInUseCheck": skip_resource_in_use_check,
        },
    )


async def describe(hub, ctx, bot_alias_id: str, bot_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get information about a specific bot alias.

    Args:
        bot_alias_id(str): The identifier of the bot alias to describe.
        bot_id(str): The identifier of the bot associated with the bot alias to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.alias.describe(
                ctx, bot_alias_id=value, bot_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.alias.describe bot_alias_id=value, bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="describe_bot_alias",
        op_kwargs={"botAliasId": bot_alias_id, "botId": bot_id},
    )


async def update(
    hub,
    ctx,
    bot_alias_id: str,
    bot_alias_name: str,
    bot_id: str,
    description: str = None,
    bot_version: str = None,
    bot_alias_locale_settings: Dict = None,
    conversation_log_settings: Dict = None,
    sentiment_analysis_settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration of an existing bot alias.

    Args:
        bot_alias_id(str): The unique identifier of the bot alias.
        bot_alias_name(str): The new name to assign to the bot alias.
        description(str, optional): The new description to assign to the bot alias. Defaults to None.
        bot_version(str, optional): The new bot version to assign to the bot alias. Defaults to None.
        bot_alias_locale_settings(Dict, optional): The new Lambda functions to use in each locale for the bot alias. Defaults to None.
        conversation_log_settings(Dict, optional): The new settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets. Defaults to None.
        sentiment_analysis_settings(Dict, optional): Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances. Defaults to None.
        bot_id(str): The identifier of the bot with the updated alias.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lexv2_model.bot.alias.update(
                ctx, bot_alias_id=value, bot_alias_name=value, bot_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lexv2_model.bot.alias.update bot_alias_id=value, bot_alias_name=value, bot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lexv2-models",
        operation="update_bot_alias",
        op_kwargs={
            "botAliasId": bot_alias_id,
            "botAliasName": bot_alias_name,
            "description": description,
            "botVersion": bot_version,
            "botAliasLocaleSettings": bot_alias_locale_settings,
            "conversationLogSettings": conversation_log_settings,
            "sentimentAnalysisSettings": sentiment_analysis_settings,
            "botId": bot_id,
        },
    )
