"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def post(
    hub,
    ctx,
    bot_name: str,
    bot_alias: str,
    user_id: str,
    input_text: str,
    session_attributes: Dict = None,
    request_attributes: Dict = None,
    active_contexts: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sends user input to Amazon Lex. Client applications can use this API to send requests to Amazon Lex at runtime. Amazon Lex then interprets the user input using the machine learning model it built for the bot.   In response, Amazon Lex returns the next message to convey to the user an optional responseCard to display. Consider the following example messages:     For a user input "I would like a pizza", Amazon Lex might return a response with a message eliciting slot data (for example, PizzaSize): "What size pizza would you like?"     After the user provides all of the pizza order information, Amazon Lex might return a response with a message to obtain user confirmation "Proceed with the pizza order?".     After the user replies to a confirmation prompt with a "yes", Amazon Lex might return a conclusion statement: "Thank you, your cheese pizza has been ordered.".     Not all Amazon Lex messages require a user response. For example, a conclusion statement does not require a response. Some messages require only a "yes" or "no" user response. In addition to the message, Amazon Lex provides additional context about the message in the response that you might use to enhance client behavior, for example, to display the appropriate client user interface. These are the slotToElicit, dialogState, intentName, and slots fields in the response. Consider the following examples:    If the message is to elicit slot data, Amazon Lex returns the following context information:    dialogState set to ElicitSlot     intentName set to the intent name in the current context     slotToElicit set to the slot name for which the message is eliciting information     slots set to a map of slots, configured for the intent, with currently known values       If the message is a confirmation prompt, the dialogState is set to ConfirmIntent and SlotToElicit is set to null.    If the message is a clarification prompt (configured for the intent) that indicates that user intent is not understood, the dialogState is set to ElicitIntent and slotToElicit is set to null.     In addition, Amazon Lex also returns your application-specific sessionAttributes. For more information, see Managing Conversation Context.

    Args:
        bot_name(str): The name of the Amazon Lex bot.
        bot_alias(str): The alias of the Amazon Lex bot.
        user_id(str): The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At runtime, each request must contain the userID field. To decide the user ID to use for your application, consider the following factors.   The userID field must not contain any personally identifiable information of the user, for example, name, personal identification numbers, or other end user personal information.   If you want a user to start a conversation on one device and continue on another device, use a user-specific identifier.   If you want the same user to be able to have two independent conversations on two different devices, choose a device-specific identifier.   A user can't have two independent conversations with two different versions of the same bot. For example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will need to have conversation with two different versions, for example, while testing, include the bot alias in the user ID to separate the two conversations.  .
        session_attributes(Dict, optional): Application-specific information passed between Amazon Lex and a client application. For more information, see Setting Session Attributes. Defaults to None.
        request_attributes(Dict, optional): Request-specific information passed between Amazon Lex and a client application. The namespace x-amz-lex: is reserved for special attributes. Don't create any request attributes with the prefix x-amz-lex:. For more information, see Setting Request Attributes. Defaults to None.
        input_text(str): The text that the user entered (Amazon Lex interprets this text).
        active_contexts(List, optional): A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request, If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_runtime.text.post(
                ctx, bot_name=value, bot_alias=value, user_id=value, input_text=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_runtime.text.post bot_name=value, bot_alias=value, user_id=value, input_text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-runtime",
        operation="post_text",
        op_kwargs={
            "botName": bot_name,
            "botAlias": bot_alias,
            "userId": user_id,
            "sessionAttributes": session_attributes,
            "requestAttributes": request_attributes,
            "inputText": input_text,
            "activeContexts": active_contexts,
        },
    )
