"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete_multiple(hub, ctx, bot_name: str, user_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes stored utterances. Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the GetUtterancesView operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input. Use the DeleteUtterances operation to manually delete stored utterances for a specific user. When you use the DeleteUtterances operation, utterances stored for improving your bot's ability to respond to user input are deleted immediately. Utterances stored for use with the GetUtterancesView operation are deleted after 15 days. This operation requires permissions for the lex:DeleteUtterances action.

    Args:
        bot_name(str): The name of the bot that stored the utterances.
        user_id(str):  The unique identifier for the user that made the utterances. This is the user ID that was sent in the PostContent or PostText operation request that contained the utterance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.utterance.init.delete_multiple(
                ctx, bot_name=value, user_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.utterance.init.delete_multiple bot_name=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="delete_utterances",
        op_kwargs={"botName": bot_name, "userId": user_id},
    )
