"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__sub_alias__ = ["slot_type_", "slot_type"]


async def delete(hub, ctx, name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes all versions of the slot type, including the $LATEST version. To delete a specific version of the slot type, use the DeleteSlotTypeVersion operation.  You can delete a version of a slot type only if it is not referenced. To delete a slot type that is referred to in one or more intents, you must remove those references first.    If you get the ResourceInUseException exception, the exception provides an example reference that shows the intent where the slot type is referenced. To remove the reference to the slot type, either update the intent or delete it. If you get the same exception when you attempt to delete the slot type again, repeat until the slot type has no references and the DeleteSlotType call is successful.   This operation requires permission for the lex:DeleteSlotType action.

    Args:
        name(str): The name of the slot type. The name is case sensitive. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.slot_type_.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.slot_type_.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="delete_slot_type",
        op_kwargs={"name": name},
    )


async def get(hub, ctx, name: str, version: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific version of a slot type. In addition to specifying the slot type name, you must specify the slot type version. This operation requires permissions for the lex:GetSlotType action.

    Args:
        name(str): The name of the slot type. The name is case sensitive. .
        version(str): The version of the slot type. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.slot_type_.init.get(ctx, name=value, version=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.slot_type_.init.get name=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_slot_type",
        op_kwargs={"name": name, "version": version},
    )


async def get_all(
    hub, ctx, next_token: str = None, max_results: int = None, name_contains: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns slot type information as follows:    If you specify the nameContains field, returns the $LATEST version of all slot types that contain the specified string.    If you don't specify the nameContains field, returns information about the $LATEST version of all slot types.     The operation requires permission for the lex:GetSlotTypes action.

    Args:
        next_token(str, optional): A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch next page of slot types, specify the pagination token in the next request. Defaults to None.
        max_results(int, optional): The maximum number of slot types to return in the response. The default is 10. Defaults to None.
        name_contains(str, optional): Substring to match in slot type names. A slot type will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz.". Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.slot_type_.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.slot_type_.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="get_slot_types",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "nameContains": name_contains,
        },
    )


async def put(
    hub,
    ctx,
    name: str,
    description: str = None,
    enumeration_values: List = None,
    checksum: str = None,
    value_selection_strategy: str = None,
    create_version: bool = None,
    parent_slot_type_signature: str = None,
    slot_type_configurations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a custom slot type or replaces an existing custom slot type. To create a custom slot type, specify a name for the slot type and a set of enumeration values, which are the values that a slot of this type can assume. For more information, see how-it-works. If you specify the name of an existing slot type, the fields in the request replace the existing values in the $LATEST version of the slot type. Amazon Lex removes the fields that you don't provide in the request. If you don't specify required fields, Amazon Lex throws an exception. When you update the $LATEST version of a slot type, if a bot uses the $LATEST version of an intent that contains the slot type, the bot's status field is set to NOT_BUILT. This operation requires permissions for the lex:PutSlotType action.

    Args:
        name(str): The name of the slot type. The name is not case sensitive.  The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For example, because there is a built-in slot type called AMAZON.DATE, you can't create a custom slot type called DATE. For a list of built-in slot types, see Slot Type Reference in the Alexa Skills Kit.
        description(str, optional): A description of the slot type. Defaults to None.
        enumeration_values(List, optional): A list of EnumerationValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, which are additional values that help train the machine learning model about the values that it resolves for a slot.  A regular expression slot type doesn't require enumeration values. All other slot types require a list of enumeration values. When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If you are not using a Lambda function you can choose to return the value that the user entered or the first value in the resolution list as the slot value. The valueSelectionStrategy field indicates the option to use. . Defaults to None.
        checksum(str, optional): Identifies a specific revision of the $LATEST version. When you create a new slot type, leave the checksum field blank. If you specify a checksum you get a BadRequestException exception. When you want to update a slot type, set the checksum field to the checksum of the most recent revision of the $LATEST version. If you don't specify the  checksum field, or if the checksum does not match the $LATEST version, you get a PreconditionFailedException exception. Defaults to None.
        value_selection_strategy(str, optional): Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values:    ORIGINAL_VALUE - Returns the value entered by the user, if the user value is similar to the slot value.    TOP_RESOLUTION - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.   If you don't specify the valueSelectionStrategy, the default is ORIGINAL_VALUE. Defaults to None.
        create_version(bool, optional): When set to true a new numbered version of the slot type is created. This is the same as calling the CreateSlotTypeVersion operation. If you do not specify createVersion, the default is false. Defaults to None.
        parent_slot_type_signature(str, optional): The built-in slot type used as the parent of the slot type. When you define a parent slot type, the new slot type has all of the same configuration as the parent. Only AMAZON.AlphaNumeric is supported. Defaults to None.
        slot_type_configurations(List, optional): Configuration information that extends the parent built-in slot type. The configuration is added to the settings for the parent slot type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lex_model.slot_type_.init.put(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lex_model.slot_type_.init.put name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lex-models",
        operation="put_slot_type",
        op_kwargs={
            "name": name,
            "description": description,
            "enumerationValues": enumeration_values,
            "checksum": checksum,
            "valueSelectionStrategy": value_selection_strategy,
            "createVersion": create_version,
            "parentSlotTypeSignature": parent_slot_type_signature,
            "slotTypeConfigurations": slot_type_configurations,
        },
    )
